/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Account;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Activity;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Bailiff;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.InvoiceStub;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Statement;
import lu.tudor.santec.gecamed.billing.utils.TimeSpan;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import net.sf.jasperreports.engine.JasperPrint;

public interface BillingPrinterInterface {
	
	public void 	   releaseCachedObjects ();
	
	public String 	   formatAccountList (Physician p_Physician);
	
	public Bailiff 	   fetchBailiffForInvoice(Invoice p_Invoice) throws Exception;
	
	public double 	   getBailiffRateForInvoice(Invoice p_Invoice) throws Exception;
	
	public String getBailiffForPatient(Patient patient, boolean returnCountryIfForeigner) throws Exception;
	
	public JasperPrint createInvoicePrintObject (Invoice invoice, Boolean markAsCopy, HashMap<String, Object> p_Parameter, Boolean forceOriginal) throws Exception;
	
	public JasperPrint createReminderList (Collection <InvoiceStub> p_InvoiceStubs, String p_Title, HashMap<String, Object> p_Parameter) throws Exception;
	
	public JasperPrint createInvoiceList (Collection <InvoiceStub> p_InvoiceStubs, HashMap<String, Object> p_Parameter) throws Exception;
	
	public Map<Integer, Map<TimeSpan, Boolean>> getUnjoinableReportsForType (String p_TemplateType);
	
	public boolean canReportJoinReminders (int p_ReminderType, Integer p_PhysicianId, Date p_DateOfInterest);
	
	public JasperPrint createNoticePrintObject (int noOfNotice, Invoice invoice, List<Invoice> p_Invoices, Account p_Account, Date p_LetterDate, Date p_SettlementVerificationDate, HashMap<String, Object> p_Parameter) throws Exception;
	
//	public JasperPrint createFirstNoticePrintObject (Invoice invoice, List<Invoice> p_Invoices, Date p_LetterDate, Date p_SettlementVerificationDate) throws Exception;
//
//	public JasperPrint createSecondNoticePrintObject (Invoice invoice, List<Invoice> p_Invoices, Date p_LetterDate, Date p_SettlementVerificationDate) throws Exception;
	
//	public JasperPrint createDemandOfPaymentPrintObject(Invoice invoice, Account p_Account, Date letterDate, HashMap<String, Object> p_Parameter) throws Exception;
	
	public JasperPrint createTransactionList (Date p_FromDate, Date p_UntilDate, Physician p_Physician, GecamedUser p_Cashier, Boolean p_EffectiveTransactions, Boolean p_IncludeTransfers, Boolean p_OnlyTotals, HashMap<String, Object> p_Parameters) throws Exception;
	
	public JasperPrint createStatementPrintObject (Statement p_Statement, Collection <InvoiceStub> p_InvoiceStubs, HashMap<String, Object> p_Parameter) throws Exception;

	public JasperPrint createActivityList (Collection <Activity> p_Activities, Date p_From, Date p_Until, HashMap<String, Object> p_Parameters) throws Exception;
	
	public JasperPrint createIssuedInvoiceList (Collection <InvoiceStub> p_IssuedInvoices, Date p_From, Date p_Until, Boolean p_OnlyTotals, HashMap<String, Object> p_Parameters) throws Exception;
	
	public List<Account> getAccounts();
	
	public List<Account> getAccounts(Physician physician);
}
