/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.session.interfaces;

import java.util.Collection;
import java.util.Date;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Invoice;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Ledger;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Settlement;
import lu.tudor.santec.gecamed.billing.ejb.entity.beans.Transaction;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Remote
public interface AccountingInterface 
	{
	public Collection <Ledger> 		getLedgersByInvoice (Invoice p_Invoice) throws Exception;

	public Collection <Ledger> 		getAllLedgersByCashier (GecamedUser p_Cashier) throws Exception;

	public Collection <Ledger> 		getDailyLedgersByCashier (GecamedUser p_Cashier, Date p_Date) throws Exception;
	
	public Ledger 			   		saveLedger (Ledger p_Ledger) throws Exception;
	
	public Collection <Transaction> getTransactionsForPhysician (Physician p_Physician, Date p_FromDate, Date p_UntilDate, GecamedUser p_Cashier, Collection <Integer> p_SettlementIds) throws Exception;
	
	public Collection <Transaction> getTransactionsForOffice    (Date p_FromDate, Date p_UntilDate, GecamedUser p_Cashier, Collection <Integer> p_SettlementIds) throws Exception;
	
	public Invoice registerTransaction(Invoice p_Invoice, Settlement p_Method, Date p_Date, Double p_PayedAmount, Double p_ReturnedAmount, Double p_Deduction, boolean p_Revoke) throws Exception;

		
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
