/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * The Payment class represents a payment method based on eiter cash or any
 * kind of credit or debit card.
 * @author nico.mack@tudor.lu
 * @since 06/04/27 
 */

@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY) 
@Table(name = "payment", schema = "billing")

@NamedQueries 
	({
	@NamedQuery(name = Payment.c_AllPayments, 	query = "SELECT OBJECT(o) FROM Payment o")
	})

public class Payment extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private String	m_Method;
	
//***************************************************************************
//* Constants  		                                                        *
//***************************************************************************	

	public static final transient String c_AllPayments = "getAllPayments";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
	
//***************************************************************************
//* Getter and Setter Methods	                                            *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns this payments' method
 * @return Payment Method
 */
//---------------------------------------------------------------------------

@Column (name ="method", updatable=false, insertable=false)

public String getMethod() 
	{
	return m_Method;
	}

//---------------------------------------------------------------------------
/**
 * Sets the payment method
 * @param p_Method specifies the payment method
 */
//---------------------------------------------------------------------------

public void setMethod (String p_Method) 
	{
	m_Method = p_Method;
	}

//---------------------------------------------------------------------------
/**
 * Returns a printable representation of this payment method.
 */
//---------------------------------------------------------------------------

@Override
public String toString() 
	{
	return getMethod();
	}

public String toLabel()
{
	return toString();
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
