/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * Memos are little notes that can be attached to invoices, much like Post-it's.
 * Besides the note written on them, memos also keep track of who posted them
 * and when they have been posted.
 * @author nico.mack@tudor.lu
 * @since 06/07/03
 */

@Entity
@Table(name = "memo", schema = "billing")

@NamedQueries 
	({
	@NamedQuery(name = Memo.c_MemosByInvoiceId, query = "SELECT OBJECT(o) FROM Memo o WHERE o.invoiceId = :invoiceId ORDER BY o.creationDate"),
	@NamedQuery(name = Memo.c_MemosByAuthor,    query = "SELECT OBJECT(o) FROM Memo o WHERE o.author = :author ORDER BY o.creationDate")
	})

public class Memo extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;

	private Integer		m_InvoiceId;
	private Date		m_CreationDate;
	private GecamedUser	m_Author;
	private String		m_Note;
	
//***************************************************************************
//* Constants				                                              	*
//***************************************************************************	

	public static final transient String c_MemosByInvoiceId  = "getMemosByInvoiceId";
	public static final transient String c_MemosByAuthor 	 = "getMemosByAuthor";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	

public Memo ()
	{
	m_CreationDate = new Date ();
	m_Note		  = new String ();
	}	

//***************************************************************************
//* Getter and Setter Methods	                                            *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the ID of the invoice this memo is attached to
 * @return the ID of the invoice
 */
//---------------------------------------------------------------------------

@Column(name = "invoice_id", updatable=false, insertable=false)
public Integer getInvoiceId() 
	{
	return m_InvoiceId;
	}

//---------------------------------------------------------------------------
/**
 * Sets the ID of the invoice this memo is attached to
 * @param p_InvoiceId specifies the ID of the invoice  this memo is attached to
 */
//---------------------------------------------------------------------------

public void setInvoiceId (Integer p_InvoiceId)
	{
	m_InvoiceId = p_InvoiceId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the creation date of this memo
 * @return  Memo creation date
 */
//---------------------------------------------------------------------------

@Column (name ="created")

public Date getCreationDate() 
	{
	return m_CreationDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the creation of this memo
 * @param p_CreationDate specifies the creation date of this memo
 */
//---------------------------------------------------------------------------

public void setCreationDate (Date p_CreationDate) 
	{
	m_CreationDate = (p_CreationDate != null) ? new Date (p_CreationDate.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * Returns the author of this memo
 * @return The user who created this memo
 */
//---------------------------------------------------------------------------

@ManyToOne (fetch = javax.persistence.FetchType.LAZY)
@JoinColumn (name ="author_id")

public GecamedUser getAuthor() 
	{
	return m_Author;
	}

//---------------------------------------------------------------------------
/**
 * Sets the author of this memo
 * @param p_Author specifies the user who created this memo
 */
//---------------------------------------------------------------------------

public void setAuthor (GecamedUser p_Author) 
	{
	m_Author = p_Author;
	}

//---------------------------------------------------------------------------
/**
 * Returns the actual text of this memo
 * @return memo text
 */
//---------------------------------------------------------------------------

@Column (name ="note")

public String getNote() 
	{
	return m_Note;
	}

//---------------------------------------------------------------------------
/**
 * Sets the actual text of this memo
 * @param p_Note specifies the new text for this memo
 */
//---------------------------------------------------------------------------

public void setNote (String p_Note) 
	{
	m_Note = p_Note;
	}


public Memo clone(boolean quiet) {
	Memo m = (Memo) super.clone(quiet);
	m.setId(null);
	m.setInvoiceId(null);
	return m;
}



//***************************************************************************
//* End of Class															*
//***************************************************************************
}
