/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * The KeyValueEntity class represents the values as defined by the UCM (Union des
 * Caisses de Maladies) to convert Rate coefficients into monetary values.
 * Key values are subject to change over time, thus the concept of a next
 * value and an applicabilty date.
 * @author nico.mack@tudor.lu
 * @since 06/04/19
 *
 */

@Entity
@Table(name = "key_value", schema = "billing")

@NamedQueries 
	({
	@NamedQuery(name = KeyValue.c_AllKeyValues, 	query = "SELECT OBJECT(o) FROM KeyValue o ORDER BY o.keyType, o.applicability DESC"),
	@NamedQuery(name = KeyValue.c_KeyValuesByKeyType, query = "SELECT OBJECT(o) FROM KeyValue o WHERE o.keyType = :keyType ORDER BY o.applicability DESC"),
	})

public class KeyValue extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	public static final int	TYPE_UNCONVENTIONAL		= 0;
	public static final int	TYPE_MEDICS				= 1;
	public static final int	TYPE_LABORATORIES		= 2;
	public static final int	TYPE_DENTISTS			= 3;
	
	
	private String	m_Label;
	private Integer m_KeyType;
	private String  m_Description;
	private Double	m_Value;
//	private Double	m_NextValue;
	private Date	m_Applicability;
	private Integer m_FractionDigits;
	private Boolean m_Editable;
	private Boolean m_Protected;
	
//***************************************************************************
//* Constants				                                              	*
//***************************************************************************	
	
	public static transient final String c_AllKeyValues    	= "getAllKeyValues";
	public static transient final String c_KeyValuesByKeyType = "getKeyValuesByKeyType";

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------

public KeyValue ()
	{
	m_Value 			= Double.valueOf(0d);
//	m_NextValue    		= Double.valueOf(0d);
	m_Applicability 		= new Date ();
	m_FractionDigits 	= Integer.valueOf(1);
	m_Protected			= Boolean.FALSE;
	}	
		

//***************************************************************************
//* Primitives				                                                *
//***************************************************************************	
////---------------------------------------------------------------------------
///**
// * Returns the value of this key value
// * @param p_DateOfInterest specifies the date to get value of this key value
// * for. Method returns current value if specified date is <code>null</code>.
// * @return the value of this key value as its defined for the specified date
// */
////---------------------------------------------------------------------------
//
//@Transient
//public Double getValue (Date p_DateOfInterest) 
//	{
//	if (p_DateOfInterest == null) return this.getCurrentValue();
//	
//	if (p_DateOfInterest.before (this.getApplicability()))
//			 return this.getCurrentValue();
//		else return this.getNextValue();			
//	}

//***************************************************************************
//* Getter and Setter Methods	                                            *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the label defined for this key value
 * @return Returns this key values label.
 */
//---------------------------------------------------------------------------

@Column (name ="label")

public String getLabel() 
	{
	return m_Label;
	}

//---------------------------------------------------------------------------
/**
 * Sets this key values label.
 * @param p_Label specifies the new label for this key value
  */
//---------------------------------------------------------------------------

public void setLabel (String p_Label) 
	{
	m_Label = p_Label;
	}


//---------------------------------------------------------------------------
/**
* Returns the key_type defined for this key value
* @return Returns this key values key Type.
*/
//---------------------------------------------------------------------------

@Column (name ="key_type")

public Integer getKeyType() 
	{
	return m_KeyType;
	}

//---------------------------------------------------------------------------
/**
* Sets this keyvalues key_type.
* @param p_Label specifies the new key_type for this key value
*/
//---------------------------------------------------------------------------

public void setKeyType (Integer p_KeyType) 
	{
	m_KeyType = p_KeyType;
	}

//---------------------------------------------------------------------------
/**
 * Returns the description defined for this key value.
 * @return Returns this key values description.
 */
//---------------------------------------------------------------------------

@Column (name ="description")

public String getDescription() 
	{
	return m_Description;
	}

//---------------------------------------------------------------------------
/**
 * Sets this key values description.
 * @param p_Description specifies the new description for this key value
  */
//---------------------------------------------------------------------------

public void setDescription (String p_Description) 
	{
	m_Description = p_Description;
	}

//---------------------------------------------------------------------------
/**
 * Returns the value of this key value
 * @return Returns this key values  value.
 */
//---------------------------------------------------------------------------

@Column (name ="value")

public Double getValue() 
	{
	return m_Value;
	}

//---------------------------------------------------------------------------
/**
 * Sets this key values value.
 * @param p_Value specifies the new value for this key value
  */
//---------------------------------------------------------------------------

public void setValue (Double p_CurrentValue) 
	{
	m_Value = p_CurrentValue;
	}

////---------------------------------------------------------------------------
///**
// * @return Returns this key values next value, applicable as of date specified
// * by applicable field.
// */
////---------------------------------------------------------------------------
//
//@Column (name ="next_value")
//
//public Double getNextValue() 
//	{
//	return m_NextValue;
//	}
//
////---------------------------------------------------------------------------
///**
// * Sets this key values next value
// * @param p_NextValue specifies the new futur value for this key value
// * to.
// */
////---------------------------------------------------------------------------
//
//public void setNextValue (Double p_NextValue) 
//	{
//	m_NextValue = p_NextValue;
//	}

//---------------------------------------------------------------------------
/**
 * @return Returns the date as of which this key values next value is applicable
 */
//---------------------------------------------------------------------------	
	
@Column (name ="applicability")

public Date getApplicability() 
	{
	return m_Applicability;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets this key values' application date for the next value
 * @param p_Applicabilty specifies the application date for key values' next value
 */
//---------------------------------------------------------------------------

public void setApplicability (Date p_Applicabilty) 
	{
	m_Applicability = (p_Applicabilty != null) ? new Date (p_Applicabilty.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * @return Returns the number of fraction digits to round to when using this
 * key value
 */
//---------------------------------------------------------------------------	
	
@Column (name ="fraction_digits")

public Integer getFractionDigits() 
	{
	return m_FractionDigits;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the number of fraction digits for this key value.
 * @param p_FractionDigits specifies the new number of fraction digits for
 * this key value.
 */
//---------------------------------------------------------------------------

public void setFractionDigits (Integer p_FractionDigits) 
	{
	m_FractionDigits = p_FractionDigits;
	}

//---------------------------------------------------------------------------
/**
 * @return Returns whether or not rates refering to this key value are can
 * be edited or not.
 */
//---------------------------------------------------------------------------	
	
@Column (name ="editable")

public Boolean getEditable() 
	{
	return m_Editable;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the state of the editable flag for this key value.
 * @param p_Editable specifies the new value for the editable flag.
 */
//---------------------------------------------------------------------------

public void setEditable (Boolean p_Editable) 
	{
	m_Editable = p_Editable;
	}

//---------------------------------------------------------------------------
/**
 * @return Returns wether or not this key values is marked as protected
 */
//---------------------------------------------------------------------------	
	
@Column (name ="protected")

public Boolean getProtected() 
	{
	return m_Protected;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the state of the protected flag for this key value.
 * @param p_Protected specifies the new value for the protected flag.
 */
//---------------------------------------------------------------------------

public void setProtected (Boolean p_Protected) 
	{
	m_Protected = p_Protected;
	}

public String toString() {
	return getLabel() + (getKeyType() != null?" ["+getKeyType()+"]":"");
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
