/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * When a bailiff is asked to execute a court order regarding demands of
 * payments, a fee is applicable. The amount of the fee being charged depends
 * on the amount of the intitial invoice.
 * @author nico.mack@tudor.lu
 * @since 07/04/20 
 */

@Entity
@Table(name = "bailiff_rate", schema = "billing")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = BailiffRate.c_AllBailiffRates, query = "SELECT OBJECT(o) FROM BailiffRate o")
	})

public class BailiffRate extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private Integer				m_BailiffId;
	private Double				m_LowerThreshold;
	private Double				m_UpperThreshold;
	private Double				m_Rate;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
	
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************	

	public static final transient String c_AllBailiffRates  = "getAllBailiffRates";
	
//***************************************************************************
//* Getter and Setter Methods	                                            *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the ID of the bailiff this rate applies to.
 * @return ID of the bailiff this rate applies to.
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="bailiff_id")

public Integer getBailiffId() 
	{
	return m_BailiffId;
	}

//---------------------------------------------------------------------------
/**
 * Sets the ID of the bailiff this rate applies to.
 * @param p_BailiffId specifies the bailiff this rate applies to.
 */
//---------------------------------------------------------------------------

public void setBailiffId (Integer p_BailiffId) 
	{
	m_BailiffId = p_BailiffId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the value of the lower threshold for this rate to be applicable
 * @return lower threshold for this rate
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="lower")

public Double getLowerThreshold() 
	{
	return m_LowerThreshold;
	}

//---------------------------------------------------------------------------
/**
 * Sets the value of the lower threshold for this rate to be applicable
 * @param p_LowerThreshold specifies the new value for the lower threshold
 */
//---------------------------------------------------------------------------

public void setLowerThreshold (Double p_LowerThreshold) 
	{
	m_LowerThreshold = p_LowerThreshold;
	}

//---------------------------------------------------------------------------
/**
 * Returns the value of the upper threshold for this rate to be applicable
 * @return upper threshold for this rate
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="upper")

public Double getUpperThreshold() 
	{
	return m_UpperThreshold;
	}

//---------------------------------------------------------------------------
/**
 * Sets the value of the upper threshold for this rate to be applicable
 * @param p_UpperThreshold specifies the new value for the upper threshold
 */
//---------------------------------------------------------------------------

public void setUpperThreshold (Double p_UpperThreshold) 
	{
	m_UpperThreshold = p_UpperThreshold;
	}

//---------------------------------------------------------------------------
/**
 * Returns the rate to be applied if invoice amount is between lower and upper
 * threshold
 * @return the rate to be applied
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="rate")

public Double getRate() 
	{
	return m_Rate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the rate to be applied if invoice amount is between lower and upper
 * threshold
 * @param p_Rate specifies the new value for the rate to be applied
 */
//---------------------------------------------------------------------------

public void setRate (Double p_Rate) 
	{
	m_Rate = p_Rate;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
