/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.billing.ejb.entity.beans;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Municipality;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * From a legal point of view, the bailiff is an officer of the court in
 * charge to execute court orders. In the scope of the billing module,
 * the bailiffs mission consists in making sure a demand of payment is executed.
 * Court jurisdiction depends on the municipality of residence of patient.
 * @author nico.mack@tudor.lu
 * @since 07/04/20 
 */

@Entity
@Table(name = "bailiff", schema = "billing")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = Bailiff.c_AllBailiffs, 			 query = "SELECT OBJECT(o) FROM Bailiff o"),
	@NamedQuery(name = Bailiff.c_BailiffByMunicipality,  query = "SELECT OBJECT(o) FROM Bailiff o WHERE :municipality MEMBER OF o.municipalities")
	})

public class Bailiff extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private String				m_Name;
	private Set <Municipality>	m_Municipalities;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
	
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************	

	public static final transient String c_AllBailiffs 		  = "getAllBailiffs";
	public static final transient String c_BailiffByMunicipality = "getBailiffByMunicipality";
	
//***************************************************************************
//* Getter and Setter Methods	                                            *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the name of this bailiff
 * @return name of the bailiff
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="name")

public String getName() 
	{
	return m_Name;
	}

//---------------------------------------------------------------------------
/**
 * Sets this bailiff's name
 * @param p_Name specifies the new name for this bailiff
 */
//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * Returns the municipalities this bailiff's jurisdiction applies to
 * @return The Municipalities this bailiff's jurisdiction applies to
 */
//---------------------------------------------------------------------------

@ManyToMany(cascade = {CascadeType.PERSIST, CascadeType.MERGE}, fetch = FetchType.LAZY)
		   @JoinTable(name = "rel_municipality_bailiff", schema = "billing",
				   	 joinColumns 			= {@JoinColumn(name = "bailiff_id")},
				   	 inverseJoinColumns 	= {@JoinColumn(name = "municipality_id")})

public Set<Municipality> getMunicipalities() 
	{
	return m_Municipalities;
	}

//---------------------------------------------------------------------------
/**
 * Sets municipalities this bailiff's jurisdiction applies to
 * @param p_Municipalities specifies the municipalities this bailiff's 
 * jurisdiction applies to
 */
//---------------------------------------------------------------------------

public void setMunicipalities (Set<Municipality> p_Municipalities)
	{
	m_Municipalities = p_Municipalities;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
