package lu.tudor.santec.gecamed.backup.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.LoginBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

public class NotifyUsersDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	private static final CellConstraints CC 		= new CellConstraints();
	
	private static final RowSpec DEFAULT_ROW 		= new RowSpec(RowSpec.FILL, Sizes.PREFERRED, 0.0);
	
	private static final RowSpec EMPTY_ROW 			= new RowSpec(Sizes.pixel(5));
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private JPanel 			usersSelectionPanel;
	
	private JCheckBox 		sendToAllBox;
	
	private LoginInterface 	loginManager;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS & INITIALISATION
	/* ======================================== */
	
	public NotifyUsersDialog(JDialog parent)
	{
		super(parent, Translatrix.getTranslationString("backup.NotifyUsersDialog.title"), OK_CANCEL_BUTTON_MODE);
		init();
	}
	
	
//	public NotifyUsersDialog(JFrame parent)
//	{
//		super(parent, Translatrix.getTranslationString("Select Users to notify if backup fails"), OK_CANCEL_BUTTON_MODE);
//		init();
//	}
	
	
	private void init ()
	{
		JScrollPane usersSelectionScroller;
		JLabel description = new JLabel(
				Translatrix.getTranslationString("backup.NotifyUsersDialog.description"));
		
		sendToAllBox 			= new JCheckBox(new AbstractAction(
				Translatrix.getTranslationString("backup.NotifyUsersDialog.allUsers"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
				enableBoxes();
			}
		});
		sendToAllBox.setOpaque(false);
		
		usersSelectionPanel 	= new JPanel();
		usersSelectionPanel.setOpaque(false);
		usersSelectionScroller 	= new JScrollPane(usersSelectionPanel);
		usersSelectionScroller.setOpaque(false);
		usersSelectionScroller.getViewport().setOpaque(false);
		usersSelectionScroller.setBorder(BorderFactory.createEmptyBorder());
		usersSelectionScroller.getVerticalScrollBar().setUnitIncrement(16);
		
		mainPanel.setLayout(new FormLayout("5px, p, 5px", "5px, p, 10px, p, 10px, min(p; 250px)"));
		mainPanel.add(description, 				CC.xy(2, 2));
		mainPanel.add(sendToAllBox, 			CC.xy(2, 4));
		mainPanel.add(usersSelectionScroller, 	CC.xy(2, 6));
	}
	
	
	public List<Integer> showUp (List<Integer> notifiedUserIDs)
	{
		// before the dialog is shown
		LoginInterface 			manager = getLoginManager();
		Collection<GecamedUser> users 	= manager.getAllUsers();
		JCheckBox 				userBox;
		FormLayout 				usersSelectionLayout = new FormLayout ("f:p");
		
		HashMap<JCheckBox, GecamedUser> idsOfBoxes = new HashMap<JCheckBox, GecamedUser>();
		Set<JCheckBox> 					boxes;
		
		usersSelectionPanel.removeAll();
		usersSelectionPanel.setLayout(usersSelectionLayout);
		
		sendToAllBox.setSelected(notifiedUserIDs.contains(-1));
		
		for (GecamedUser user : users)
		{
			userBox = new JCheckBox(user.getName());
			userBox.setOpaque(false);
			userBox.setSelected(notifiedUserIDs.contains(user.getId()));
			idsOfBoxes.put(userBox, user);
			
			usersSelectionLayout.appendRow(DEFAULT_ROW);
			usersSelectionPanel.add(userBox, CC.xy(1, usersSelectionLayout.getRowCount()));
			usersSelectionLayout.appendRow(EMPTY_ROW);
		}
		
		enableBoxes();
		
		// show the dialog
		pack();
		setLocationRelativeTo(getOwner());
		setVisible(true);
		
		// after the dialog was closed
		if (buttonOption == OK_OPTION)
		{
			notifiedUserIDs = new LinkedList<Integer>();
			
			if (sendToAllBox.isSelected())
				notifiedUserIDs.add(-1);
			
			boxes = idsOfBoxes.keySet();
			for (JCheckBox box : boxes)
			{
				if (box.isSelected())
					notifiedUserIDs.add(idsOfBoxes.get(box).getId());
			}
		}
		
		return notifiedUserIDs;
	}
	
	
	private LoginInterface getLoginManager ()
	{
		if (loginManager == null)
			loginManager = (LoginInterface)ManagerFactory.getRemote(LoginBean.class);
		
		return loginManager;
	}
	
	
	private void enableBoxes()
	{
		boolean 	enable 		= !sendToAllBox.isSelected();
		Component[] components 	= usersSelectionPanel.getComponents();
		
		for (Component c : components)
			c.setEnabled(enable);
	}
}
