/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.backup.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

    @javax.persistence.NamedQueries({
        @javax.persistence.NamedQuery(name="findAllBackupUser",
            query="SELECT OBJECT(o) FROM BackupUser o ORDER BY o.id ASC"),
        @NamedQuery(name=BackupUser.FIND_USER_BY_LOGIN,
        	query="SELECT OBJECT(o) FROM BackupUser o WHERE o.login = :login")
 })


@javax.persistence.Entity
@javax.persistence.Table(name = "gecamed_user", schema ="usermanagement")
public class BackupUser extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final String FIND_USER_BY_LOGIN = "findBackupUserByLogin";
	
	private boolean hasChanges;
	private Date passwordDate;
	private java.lang.String login;
	private Date lastModification;
	private java.lang.Integer modifiedBy;
	private java.lang.String name;
	private java.lang.String passwordhash;
	private String language;
	
	public BackupUser(){
		
	}
	
	public BackupUser(String name) {
		this.name = name;
	}
	



	/**
	 * Get the lastModification.
	 *
	 * @return The lastModification.
	 */
	@javax.persistence.Column(name = "last_modification")
	public Date getLastModification() {
		return lastModification;
	}

	/**
	 * Set the lastModification.
	 *
	 * @param lastModification The lastModification.
	 */
	public void setLastModification(Date lastModification) {
		this.lastModification = lastModification;
	}



	/**
	 * Get the login name of the user.
	 *
	 * @return The login name of the user.
	 */
	@javax.persistence.Column(name = "login")
	public java.lang.String getLogin() {
		return login;
	}

	/**
	 * Set the login name of the user.
	 *
	 * @param login The login name of the user.
	 */
	public void setLogin(java.lang.String login) {
		this.login = login;
	}



	/**
	 * Get the modifiedBy.
	 *
	 * @return The modifiedBy.
	 */
	@javax.persistence.Column(name = "modified_by")
	public java.lang.Integer getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * Set the modifiedBy.
	 *
	 * @param modifiedBy The modifiedBy.
	 */
	public void setModifiedBy(java.lang.Integer modifiedBy) {
		this.modifiedBy = modifiedBy;
	}



	/**
	 * Get the full name of the user.
	 *
	 * @return The full name of the user.
	 */
	@javax.persistence.Column(name = "name")
	public java.lang.String getName() {
		return name;
	}

	/**
	 * Set the full name of the user.
	 *
	 * @param name The full name of the user.
	 */
	public void setName(java.lang.String name) {
		this.name = name;
	}



	/**
	 * Get the passwordhash.
	 *
	 * @return The passwordhash.
	 */
	@javax.persistence.Column(name = "passwordhash")
	public java.lang.String getPasswordhash() {
		return passwordhash;
	}

	/**
	 * Set the passwordhash.
	 *
	 * @param passwordhash The passwordhash.
	 */
	public void setPasswordhash(java.lang.String passwordhash) {
		this.passwordhash = passwordhash;
	}

    	
	/**
	 * sets the language of the user
	 * @return the language of the user
	 */
	@Column(name = "language")
	public String getLanguage() {
		return this.language;
	}
	
	/**
	 * gets the language of the user
	 * @param language the language of the user
	 */
	public void setLanguage(String language) {
		this.language = language;
	}
	
//---------------------------------------------------------------------------

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.name;
    }


	/**
	 * returns if the user has unsaved the changes.
	 * @return true if the user has unsaved the changes.
	 */
    @Transient
	public boolean hasChanges() {
		return hasChanges;
	}

	/**
	 * sets if the user has unsaved the hasChanges.
	 * @param hasChanges true if the user has unsaved Changes.
	 */
    @Transient
	public void setHasChanges(boolean hasChanges) {
		this.hasChanges = hasChanges;
	}

	/**
	 * returns the date when the users password was set
	 * @return Returns the date when the users password was set
	 */
    @Column(name = "password_date")
	public Date getPasswordDate() {
		return passwordDate;
	}

	/**
	 * sets the date when the users password was set
	 * @param passwordDate the date when the users password was set
	 */
	public void setPasswordDate(Date passwordDate) {
		this.passwordDate = passwordDate;
	}

}


    

