/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.utils;

import java.util.HashMap;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;

/**
 * Tiny rule engine for appointments<br/>
 * Submit a rule string to access the elements or create a new object and
 * construct a new rule string.<br/>
 * See Appointment for details on how to create RRules strings
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 */
public class RRule {

	HashMap<String, String> elements = new HashMap<String, String>();
	
	private String ruleString;

	/**
	 * 
	 */
	public RRule() {
	};
	
	/**
	 * Constructor to create a RRule object with a rule string
	 * 
	 * @param ruleString
	 */
	public RRule(String ruleString) {
		/* ================================================== */
		this.ruleString = ruleString;
		
		String[] tempS = this.ruleString.split(";");
		
		for (int i = 0; i < tempS.length; i++) {
			try {
				String[] parts = tempS[i].split("=");
				elements.put(parts[0], parts[1]);
			} catch (Exception e) {
			}
		}
		/* ================================================== */
	}
		
	/**
	 * Returns the intervall of the rule.<br/>
	 * Values:
	 * <ul>
	 * <li>NO_RECUR = 0;</li>
	 * <li>DAILY 	 = 1;</li>
	 * <li>WEEKLY 	 = 2;</li>
	 * <li>MONTHLY  = 3;</li>
	 * <li>YEARLY 	 = 4;</li>
	 * </ul>
	 * 
	 * @return
	 */
	public Integer getInterval() {
		/* ================================================== */
		return Integer.parseInt(elements.get(Appointment.INTERVAL));
		/* ================================================== */
	}
	
	/**
	 * Returns the weekdays on which the event recurrs.
	 * Values are weekdays from Java Calendar.
	 * 
	 * @return
	 */
	public int[] getWeekDays() {
		/* ================================================== */
		String weekdays = (String)elements.get(Appointment.BYDAY);
		if (weekdays != null) {
			String[] days = weekdays.split(",");
			int[] dayConstants = new int[days.length];
			for (int i = 0; i < dayConstants.length; i++) {
				dayConstants[i] = Integer.parseInt(days[i]);
			}
			return dayConstants;
		}
		return new int[0];
		/* ================================================== */
	}
	
	/**
	 * Returns the value of a rule engine key.
	 * 
	 * @param key
	 * @return
	 */
	public String getElement(String key) {
		/* ================================================== */
		return elements.get(key);
		/* ================================================== */
	}
	
	
	/**
	 * @return returns the rule string
	 */
	public String getRule() {
		/* ================================================== */
		StringBuffer buff = new StringBuffer();
		for (String key : elements.keySet()) {
			buff.append(key+"="+elements.get(key) + ";");
		}
		return buff.toString();
		/* ================================================== */
	}
	
	
	/**
	 * Put an element to the rule string
	 * 
	 * @param key
	 * @param value
	 */
	public void putElement(String key, String value) {
		if (key != null && !"".equals(key)) {
			elements.put(key, value);
		}
	}
	
	
}
