package lu.tudor.santec.gecamed.agenda.utils;

import java.util.Collection;
import java.util.Vector;

import lu.tudor.santec.ftp.FTPClient;
import lu.tudor.santec.ftp.FTPClientException;
import lu.tudor.santec.ftp.FTPFileDescriptor;
import lu.tudor.santec.gecamed.core.utils.Logger;

import org.apache.log4j.Level;

/**
 * @author hermenj
 *
 *
 * @version
 * <br>$Log: FTPManager.java,v $
 */
public class DoctenaFTPManager
	{
	private static Logger		m_Logger = new Logger (DoctenaFTPManager.class);
	
	private FTPClient			m_FtpClient;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public DoctenaFTPManager ()
	{
	m_FtpClient 	= new FTPClient (false);	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************

//---------------------------------------------------------------------------

public boolean isConnected ()
	{
	return m_FtpClient.isConnected();
	}

//---------------------------------------------------------------------------

public boolean openConnection (String server, Integer port, String username, String password) throws Exception
	{

	if (m_FtpClient.isConnected()) m_FtpClient.disconnectFromServer();
	
	m_FtpClient.setPassiveMode(true);
	if (port != null) m_FtpClient.setPort(port);

	m_FtpClient.connectToServer(server, username, password);

	return m_FtpClient.isConnected();
	}

//---------------------------------------------------------------------------

public Collection <String> getListOfAvailableAppointments (String inbox, String doctenaFilenamePattern) throws Exception
	{
	Collection <String>	l_AvailableResults	= null;
	FTPFileDescriptor	l_Descriptor		= null;
	String				l_Filename			= null;
	
	if (!m_FtpClient.isConnected()) return null;

		if (inbox != null) {
			m_FtpClient.buildFileList(inbox);
		} else {
			m_FtpClient.buildFileList("./");			
		}
		
		if (doctenaFilenamePattern != null) {
			m_FtpClient.setFileMatchPattern (doctenaFilenamePattern);			
		}

        l_AvailableResults = new Vector <String> ();
        
        do  {
            l_Descriptor = m_FtpClient.getNextFileDescriptor (FTPFileDescriptor.c_File);
 
            if (l_Descriptor != null) 
                {    
                l_Filename = l_Descriptor.getFileName();
                l_AvailableResults.add(l_Filename);
                }
        	}
        while (l_Descriptor != null);

	return l_AvailableResults;
	}

//---------------------------------------------------------------------------

public byte[] downloadAppointment (String p_ResultFilename) throws FTPClientException
	{
	byte[] l_ResultData = null;
	
	if (!m_FtpClient.isConnected()) return null;
		
//	m_Logger.log (Level.DEBUG,"Downloading Appointment file " + p_ResultFilename + " !");			

	l_ResultData = m_FtpClient.fetchData (p_ResultFilename, FTPClient.c_ASCII);

	return l_ResultData;
	}

//---------------------------------------------------------------------------

public void renameFile (String p_OldFileName, String p_NewFileName) throws Exception
	{
	byte[] check = null;
	
	m_FtpClient.renameFile (p_OldFileName, p_NewFileName);
		check = m_FtpClient.fetchData(p_NewFileName, FTPClient.c_ASCII);
	if (check == null)
		throw new Exception("Error while moving file on server" + p_OldFileName);
	}

//---------------------------------------------------------------------------

public void uploadFile (byte[] p_Content, String p_Filename) throws Exception
{
	byte[] check = null;
	m_FtpClient.changeDirectory("/");
	m_FtpClient.putData(p_Filename, p_Content, FTPClient.c_Binary);
	
	check = m_FtpClient.fetchData(p_Filename, FTPClient.c_Binary);
	if (check == null) {		
		throw new Exception("Error while uploading file to server" + p_Filename);
	}
}

//---------------------------------------------------------------------------


public void closeConnection ()
	{
	if (m_FtpClient.isConnected()) m_FtpClient.disconnectFromServer();	
	}

//---------------------------------------------------------------------------

public static void main(String[] args) {
	
	try {
		DoctenaFTPManager ftp = new DoctenaFTPManager();
		ftp.openConnection("santec-dev", 21, "santec", "xxxx");
		
		Collection<String> files = ftp.getListOfAvailableAppointments("input", null);
		for (String string : files) {
			System.out.println(string);
		}
		
		byte[] data = new byte[] {1,2,3,4};
		
		ftp.uploadFile(data, "gecamed_blocked.ics");
		
		ftp.closeConnection();
		
	} catch (Exception e) {
		e.printStackTrace();
	}
	
	
	
}


//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}