/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: TestAppointment.java,v $
 * <br>Revision 1.7  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.6  2012-06-28 15:57:19  troth
 * <br>fix bug: Ticket #878  Existing recurring appointments not taken into account by NAF (first test version).
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-21 09:27:04  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.3  2007-12-04 14:33:50  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/03/27 05:55:22  heinemann
 * <br>Revision 1.2  2007-11-20 08:58:55  hermen
 * <br>moved Managerfactory to core.utils and refactured code to use ManagerFactory instead of context.lookup
 * <br>
 * <br>Revision 1.1  2007/03/27 05:55:22  heinemann
 * <br>initial checkin
 * <br>
 *
 */
package lu.tudor.santec.gecamed.agenda.testcases;

import java.util.Date;
import java.util.Locale;

import junit.framework.TestCase;
import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;
import lu.tudor.santec.gecamed.agenda.ejb.session.beans.AppointmentManagerBean;
import lu.tudor.santec.gecamed.agenda.ejb.session.interfaces.AppointmentManager;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;

/**
 * @author martin.heinemann@tudor.lu
 * 15.03.2007
 * 17:39:57
 *
 *
 * @version
 * <br>$Log: TestAppointment.java,v $
 * <br>Revision 1.7  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.6  2012-06-28 15:57:19  troth
 * <br>fix bug: Ticket #878  Existing recurring appointments not taken into account by NAF (first test version).
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-21 09:27:04  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.3  2007-12-04 14:33:50  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/03/27 05:55:22  heinemann
 * <br>Revision 1.2  2007-11-20 08:58:55  hermen
 * <br>moved Managerfactory to core.utils and refactured code to use ManagerFactory instead of context.lookup
 * <br>
 * <br>Revision 1.1  2007/03/27 05:55:22  heinemann
 * <br>initial checkin
 * <br>
 *
 */
public class TestAppointment extends TestCase {

	private AppointmentManager manager;

	/**
	 * @param arg0
	 */
	public TestAppointment(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		
		manager = (AppointmentManager) ManagerFactory.getRemote(AppointmentManagerBean.class);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}


	public void testCheckAppointmentTypes() {
		/* ================================================== */
		Appointment ap = new Appointment();
		
		ap.setCalendarId(1);
		ap.setStartDate(new Date());
		ap.setEndDate(new Date(ap.getStartDate().getTime()+6000));
		
		Appointment re = manager.checkFreeAppointment(ap, 1, Locale.FRANCE);
		System.out.println(re);
		/* ================================================== */
	}








}
