/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;
import lu.tudor.santec.gecamed.agenda.utils.RRule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Modificaftion panel for events that should recurr weekly.
 * Has a spinner for the weeks
 * and buttons to mark the days on which the event should recurr.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:37:42
 *
 *
 * @version
 * <br>$Log: WeeklyFreqPanel.java,v $
 * <br>Revision 1.9  2012-06-28 15:32:31  troth
 * <br>Move the java class RRule from the package 'lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence' to 'lu.tudor.santec.gecamed.agenda.utils' because the class is need in the agenda beans.
 * <br>
 * <br>Revision 1.8  2011-08-05 15:06:07  troth
 * <br>fix ticket #891
 * <br>
 * <br>Revision 1.7  2011-06-16 15:13:14  troth
 * <br>fix Ticket #863 Dialog 'Wiederholungsoption' behlt alte Werte zurck
 * <br><http://santec.tudor.lu/trac/gecamed/ticket/863>
 * <br>
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class WeeklyFreqPanel extends AbstractFrequencePanel implements ActionListener {

	private static final long serialVersionUID = 1L;

	private JPanel mainPanel;

	private JPanel weekdaysPanel;
	
	private LinkedHashMap<Integer, JCheckBox> weekdays = new LinkedHashMap<Integer, JCheckBox>();
	
	private DateFormat weekdayFormat = new SimpleDateFormat("EE", Translatrix.getLocale());

	public WeeklyFreqPanel() {
		super(Translatrix.getTranslationString("calendar.recurrence.recurWeeks"));
		
		this.mainPanel = new JPanel();
		this.mainPanel.setOpaque(false);
		this.mainPanel.setLayout(new BorderLayout());
		this.weekdaysPanel = new JPanel(new GridLayout(1,0));
		this.weekdaysPanel.setOpaque(false);
		
		Calendar c = new GregorianCalendar(Translatrix.getLocale());
		c.set(Calendar.DAY_OF_WEEK, c.getFirstDayOfWeek());

		for (int i = 0; i < 7; i++) {
			JCheckBox weekday = new JCheckBox(weekdayFormat.format(c.getTime()));
			weekdaysPanel.add(weekday);
			weekday.setActionCommand(c.get(Calendar.DAY_OF_WEEK) + "");
			weekday.addActionListener(this);
			weekday.setOpaque(false);
			weekdays.put(c.get(Calendar.DAY_OF_WEEK), weekday);
			c.roll(Calendar.DAY_OF_WEEK, true);
		}
		
		this.mainPanel.add(weekdaysPanel, BorderLayout.NORTH);
		this.add(mainPanel, BorderLayout.CENTER);
	}
	
	@Override
	public void getRule(RRule rule) {
		rule.putElement(Appointment.INTERVAL, spinner.getValue() + "");

		StringBuffer reccurDays = new StringBuffer();
		for (Iterator<JCheckBox> iter = weekdays.values().iterator(); iter.hasNext();) {
			JCheckBox element = (JCheckBox) iter.next();
			if (element.isSelected()) 
				reccurDays.append(element.getActionCommand() + ",");
		}
		rule.putElement(Appointment.BYDAY, reccurDays.toString());
	}

	@Override 
	public void setRule(RRule rule) {
		try {
			this.spinner.setValue(rule.getInterval());
		} catch (Exception e) {
			this.spinner.setValue(1);
		}
		
		for (Iterator<JCheckBox> iter = weekdays.values().iterator(); iter.hasNext();) {
			JCheckBox element = (JCheckBox) iter.next();
			element.setSelected(false);
		}
		int[] reccurDays = rule.getWeekDays();
		for (int i = 0; i < reccurDays.length; i++) {
			JCheckBox weekday = weekdays.get(reccurDays[i]);
			if (weekday != null) {
				weekday.setSelected(true);
			}
		}
		
	}

	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
	}

	@Override
	public void setEnabled(boolean enabled) {
		super.setEnabled(enabled);
		Component[] components = getComponents();
		if (components != null && components.length > 0) {
			int count = components.length;
			for (int i = 0; i < count; i++)
				components[i].setEnabled(enabled);
		}
		
		components = mainPanel.getComponents();
		if (components != null && components.length > 0) {
			int count = components.length;
			for (int i = 0; i < count; i++)
				components[i].setEnabled(enabled);
		}
		
		components = weekdaysPanel.getComponents();
		if (components != null && components.length > 0) {
			int count = components.length;
			for (int i = 0; i < count; i++)
				components[i].setEnabled(enabled);
		}
	}

	/**
	 * Reset the weekdaysPanel.
	 */
	public void resetWeeklyFreqPanelPanel()
	{
		Component[] components = weekdaysPanel.getComponents();
		if (components != null && components.length > 0)
		{
			int count = components.length;
			for (int i = 0; i < count; i++)
			{
				if (components[i] instanceof JCheckBox)
				{
					((JCheckBox) components[i]).setSelected(false);
				}
			}
		}	
	}
	
	/**
	 * Selected a special day of the weekly JCheckBoxs.
	 * @param weekdayNumber is the number of the weekly JCheckBoxs (Day) which should be selected. 
	 */
	public void setWeekday(int weekdayNumber)
	{
		JCheckBox weekday = weekdays.get(weekdayNumber);
		weekday.setSelected(true);
	}
}