/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;
import lu.tudor.santec.gecamed.agenda.utils.RRule;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Modificaftion panel for events that should recurr daily.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:36:43
 *
 *
 * @version
 * <br>$Log: DailyFreqPanel.java,v $
 * <br>Revision 1.8  2012-06-28 15:32:31  troth
 * <br>Move the java class RRule from the package 'lu.tudor.santec.gecamed.agenda.gui.widgets.recurrence' to 'lu.tudor.santec.gecamed.agenda.utils' because the class is need in the agenda beans.
 * <br>
 * <br>Revision 1.7  2011-08-04 08:59:11  troth
 * <br>fix some warnings.
 * <br>
 * <br>Revision 1.6  2011-06-16 15:13:14  troth
 * <br>fix Ticket #863 Dialog 'Wiederholungsoption' behlt alte Werte zurck
 * <br><http://santec.tudor.lu/trac/gecamed/ticket/863>
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class DailyFreqPanel extends AbstractFrequencePanel {

	private static final long serialVersionUID = 1L;

	public DailyFreqPanel() {
		super(Translatrix.getTranslationString("calendar.recurrence.recurDays"));
	}
	
	@Override
	public void getRule(RRule rule) {
		rule.putElement(Appointment.INTERVAL, spinner.getValue() + "");
	}

	@Override 
	public void setRule(RRule rule) {
		try {
			this.spinner.setValue(rule.getInterval());
		} catch (Exception e) {
			this.spinner.setValue(1);
		}
	}
	
	/**
	 * Reset the spinner.
	 */
	public void resetDailyFreqPanel()
	{
		this.spinner.setValue(1);
	}	
}
