/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets.appointmenttype;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * Transferable class for drag and drop between two AppointmentType tables
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 08:24:57
 *
 *
 * @version
 * <br>$Log: AppointmentTypeTransferable.java,v $
 * <br>Revision 1.3  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class AppointmentTypeTransferable implements Transferable {
	    private Object data;
	    private static final DataFlavor[] flavors = new DataFlavor[1];
	    
	    static {flavors[0] = DataFlavor.stringFlavor;}
	   
	    public AppointmentTypeTransferable(final Object data) {
	        super();
	        this.data = data;
	    }
	    
	    public DataFlavor[] getTransferDataFlavors() {
	    	return flavors;
	    }
	    
	    public boolean isDataFlavorSupported(final DataFlavor flavor) {
	    	return true;
	    }
	    
	    public Object getTransferData(final DataFlavor flavor) throws UnsupportedFlavorException, IOException {
	        return data;
	    }
	}
