/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.ScrollPaneConstants;

import lu.tudor.santec.gecamed.agenda.gui.AgendaPrinter;
import lu.tudor.santec.gecamed.core.utils.JasperTemplateBean;
import lu.tudor.santec.i18n.Translatrix;
import bizcal.common.Event;

/**
 * @author martin.heinemann@tudor.lu
 *
 * @version
 * <br>$Log: FadingPopup.java,v $
 * <br>Revision 1.7  2013-12-27 18:08:30  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.6  2013-01-22 14:21:35  ferring
 * <br>iReport templates will now be compiled only once until the server is stopped
 * <br>
 * <br>Revision 1.5  2011-09-14 12:20:34  troth
 * <br>Add the new function for printing a appointment overview for the physician.
 * <br>
 * <br>Revision 1.4  2011-09-02 14:11:55  troth
 * <br>Add the new agenda appointment printing for patient function.
 * <br>
 * <br>Revision 1.3  2011-06-28 13:48:27  troth
 * <br>testing agenda
 * <br>
 * <br>Revision 1.1  2011-04-04 11:38:31  troth
 * <br>Redesign of the appointment create dialog and the right navi bar.
 * <br>
 */
class FadingPopup {
	
	private Popup 						pop = null;
	private JPanel 						appointmentListPanel;
	private JList 						appointmentList;
//	private Timer movingTimer;
	private Thread 						fadeThread;
	private Thread 						unfadeThread;
	private AppointmentCreateDialog 	parentDialog;
	private List<Event> 				appointmentData;
	
	/**
	 * @param parent
	 */
	public FadingPopup(AppointmentCreateDialog parentDialog) {
		/* ================================================== */
		this.parentDialog = parentDialog;
		this.appointmentListPanel = new JPanel(new BorderLayout(0, 10));
		this.appointmentListPanel.setBackground(Color.WHITE);
		
		/* ------------------------------------------------------- */
		// label on top
		JLabel topicLabel = new JLabel(Translatrix.getTranslationString("Agenda.futureAppointments")+":");
		appointmentListPanel.add(topicLabel, BorderLayout.NORTH);
		/* ------------------------------------------------------- */
		// JList in the center
		this.appointmentList = new JList();
		JScrollPane scroll = new JScrollPane(this.appointmentList);
		scroll.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		scroll.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		this.appointmentListPanel.add(scroll, BorderLayout.CENTER);
		/* ------------------------------------------------------- */
		// print button on the buttom
		JButton printButton = new JButton("print List");
		this.appointmentListPanel.add(printButton, BorderLayout.SOUTH);
		printButton.addActionListener(new ActionListener() {
			
			public void actionPerformed(ActionEvent e) {
				// limit number of Appointments to 20
				int maxNumberAppointments = 20;
				if(appointmentData.size() < maxNumberAppointments) maxNumberAppointments = appointmentData.size();
				AgendaPrinter.print(appointmentData,  
						maxNumberAppointments, 
//						AgendaPrinter.PATIENT_TEMPLATE_TYPE,
						JasperTemplateBean.AGENDA_PATIENT_APPOINTMENTS,
//						AgendaPrinter.PATIENT_DEFAULT_TEMPLATE_FILE, 
						null);
			}
		});
		/* ------------------------------------------------------- */
		this.appointmentListPanel.setBorder(BorderFactory.createTitledBorder(""));
		this.appointmentList.setCellRenderer(new FutureAppointmentEventListCellRenderer());
		/* ================================================== */
	}
	
	
	public int getAppointmentCount ()
	{
		return appointmentData == null ? 0 : appointmentData.size();
	}
	
	
	/**
	 * @param data
	 */
	public void setListData(List<Event>data) {
		/* ================================================== */
		this.appointmentData = data;
		this.appointmentList.setListData(new Vector<Event>(data));
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	public void showPopup() {
		/* ================================================== */
		fadeList();
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	public void hidePopup() {
		/* ================================================== */
		unFadeList();
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	private synchronized void fadeList() {
		/* ================================================== */
		// if there is a thread doing the fadinf, nothing else has to be done
		if (fadeThread != null && fadeThread.isAlive())
			return;
		/* ------------------------------------------------------- */
		// if the unfadeThread is working, we wait until it is finished.
		if (unfadeThread != null && unfadeThread.isAlive())
			try {
				unfadeThread.join();
			} catch (InterruptedException ie) {
				ie.printStackTrace();
			}
		/* ------------------------------------------------------- */
		// if the popup is already visible, skip
		if (pop != null)
			return;
		/* ------------------------------------------------------- */
		if (appointmentList.getModel().getSize() < 1)
			return;
		/* ------------------------------------------------------- */
		int panelWidth = 180;
		/* ------------------------------------------------------- */
		appointmentListPanel.setPreferredSize(new Dimension(panelWidth, this.parentDialog.getHeight() - 40));
		// adjust the position and size of the dialog
		int pX = this.parentDialog.getLocation().x - appointmentListPanel.getPreferredSize().width;
		int pY = this.parentDialog.getLocation().y +20;
		
		if (pop != null)
			pop.hide();
		/* ------------------------------------------------------- */
		pop = PopupFactory.getSharedInstance().getPopup(this.parentDialog,appointmentListPanel,
				pX, pY);
		/* ------------------------------------------------------- */
		pop.show();
		
		
//		this.fadeThread = new Thread() {
//			public void run() {
//				/* ------------------------------------------------------- */
//				int panelWidth = 180;
//				/* ------------------------------------------------------- */
//				for (int i = 0; i < panelWidth; i+=20) {
//					/* ------------------------------------------------------- */
//					appointmentListPanel.setPreferredSize(new Dimension(i, getHeight()-40));
//					// adjust the position and size of the dialog
//					int pX = NewAppointmentDialog.this.getLocation().x - appointmentListPanel.getPreferredSize().width;
//					int pY = NewAppointmentDialog.this.getLocation().y +20;
//					
//					if (pop != null)
//						pop.hide();
//					/* ------------------------------------------------------- */
//					pop = PopupFactory.getSharedInstance().getPopup(NewAppointmentDialog.this,appointmentListPanel,
//							pX, pY);
//					/* ------------------------------------------------------- */
//					pop.show();
//					/* ------------------------------------------------------- */
//				}
//			}
//		};
//		fadeThread.start();
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	private synchronized void unFadeList() {
		/* ================================================== */
		// if the popup is going to be visible, we wait until its done.
		if (fadeThread != null && fadeThread.isAlive())
			try {
				fadeThread.join();
			} catch (InterruptedException ie) {
				ie.printStackTrace();
			}
		/* ------------------------------------------------------- */
		if (unfadeThread != null && unfadeThread.isAlive())
			return;
		/* ------------------------------------------------------- */
		if (pop == null)
			return;
		/* ------------------------------------------------------- */
		pop.hide();
		pop = null;

//		this.unfadeThread = new Thread() {
//			public void run() {
//				/* ------------------------------------------------------- */
//				int panelWidth = 180;
//				/* ------------------------------------------------------- */
//				for (int i = panelWidth; i > 0; i-= 20) {
//					/* ------------------------------------------------------- */
//					appointmentListPanel.setPreferredSize(new Dimension(i, getHeight()-40));
//					// adjust the position and size of the dialog
//					int pX = NewAppointmentDialog.this.getLocation().x - appointmentListPanel.getPreferredSize().width;
//					int pY = NewAppointmentDialog.this.getLocation().y +20;
//					
//					if (pop != null)
//						pop.hide();
//					/* ------------------------------------------------------- */
//					pop = PopupFactory.getSharedInstance().getPopup(NewAppointmentDialog.this,appointmentListPanel,
//							pX, pY);
//					/* ------------------------------------------------------- */
//					pop.show();
////					System.out.println("Pop Hide: " + i);
//					/* ------------------------------------------------------- */
//				}
//				if (pop != null)
//					pop.hide();
//				pop = null;
////				System.out.println("Pop Hide ----- Finished");
//				/* ------------------------------------------------------- */
//			}
//		};
//		unfadeThread.start();
		/* ================================================== */
	}
}