/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: CalendarComboBoxRenderer.java,v $
 * <br>Revision 1.5  2008-10-16 14:16:12  heinemann
 * <br>fixed nullpointer when calendar has no color
 * <br>
 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.2  2007/06/21 09:01:07  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/05/31 13:00:17  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
package lu.tudor.santec.gecamed.agenda.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.AgendaCalendar;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorListRenderer;

/**
 * 
 * Renderer for AgendaCalendar objects in Comboboxes<br/>
 * Icon - Name
 * 
 * @author martin.heinemann@tudor.lu
 * 30.05.2007
 * 08:53:36
 *
 *
 * @version
 * <br>$Log: CalendarComboBoxRenderer.java,v $
 * <br>Revision 1.5  2008-10-16 14:16:12  heinemann
 * <br>fixed nullpointer when calendar has no color
 * <br>
 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.2  2007/06/21 09:01:07  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/05/31 13:00:17  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */
public class CalendarComboBoxRenderer extends LineColorListRenderer {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;


	/**
	 *
	 */
	public CalendarComboBoxRenderer() {
		/* ================================================== */
		super();
		/* ================================================== */
	}


	/* (non-Javadoc)
	 * @see javax.swing.DefaultListCellRenderer#getListCellRendererComponent(javax.swing.JList, java.lang.Object, int, boolean, boolean)
	 */
	@Override
	public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
		/* ====================================================== */
		JLabel l = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected,
				cellHasFocus);

		if (value instanceof AgendaCalendar) {
			/* ------------------------------------------------------- */
			AgendaCalendar ag = (AgendaCalendar) value;
			if (ag.getColor() != null)
				l.setIcon(new ColorIcon(new Color(ag.getColor())));
			else
				l.setIcon(new ColorIcon(Color.RED));
			
			l.setHorizontalTextPosition(SwingConstants.RIGHT);

			l.setVerticalAlignment(SwingConstants.CENTER);
			l.setHorizontalAlignment(SwingConstants.LEFT);

			l.setText(ag.getTitle());

			l.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 0));
			/* ------------------------------------------------------- */
		}
		return l;

		/* ====================================================== */
	}






	/**
	 * @author martin.heinemann@tudor.lu
	 * 30.05.2007
	 * 09:08:19
	 *
	 *
	 * @version
	 * <br>$Log: CalendarComboBoxRenderer.java,v $
	 * <br>Revision 1.5  2008-10-16 14:16:12  heinemann
	 * <br>fixed nullpointer when calendar has no color
	 * <br>
	 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
	 * <br>fixed copyrights
	 * <br>
	 * <br>Revision 1.3  2008-01-18 16:09:05  heinemann
	 * <br>code cleanup and java doc
	 * <br>
	 * <br>Revision 1.2  2007/06/21 09:01:07  hermen
	 * <br>*** empty log message ***
	 * <br>
	 * <br>Revision 1.1  2007/05/31 13:00:17  heinemann
	 * <br>*** empty log message ***
	 * <br>
	 *
	 */
	public class ColorIcon implements Icon, Serializable {

		private static final long serialVersionUID = 1L;
		private static final int ICON_W = 16;
		private static final int ICON_H = 12;

		private Color color;

		public ColorIcon(Color color) {
			this.color = color;
		}


	    public void paintIcon(Component c, Graphics g, int x, int y) {

			g.setColor(color);
			g.fillRect(x, y+1, ICON_W, ICON_H);


	    }

	    public int getIconWidth() {
	        return ICON_W;
	    }

	    public int getIconHeight() {
	        return ICON_H;
	    }
	 }



}
