/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.gui.widgets;

import javax.swing.Icon;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.agenda.ejb.entity.beans.Appointment;

/**
 * Abstract class for components that want to edit appointments in the appointment modify dialog.
 * They are placed in tabs in the dialog.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 18.01.2008
 * 09:17:48
 *
 *
 * @version
 * <br>$Log: AppointmentEditPanel.java,v $
 * <br>Revision 1.7  2011-04-05 08:43:15  troth
 * <br>fix some warnings
 * <br>
 * <br>Revision 1.6  2011-04-04 11:38:31  troth
 * <br>Redesign of the appointment create dialog and the right navi bar.
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public abstract class AppointmentEditPanel extends JPanel{

	/**
	 * Default serial version UID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * returns the modified appointment. Normally called to save the appointment
	 * 
	 * @param appointment
	 */
	public abstract void getAppointment(Appointment appointment);
	
	/**
	 * Set the appointment to edit.
	 * 
	 * @param appointment
	 */
	public abstract void setAppointment(Appointment appointment);

	/**
	 * An icon for the tab.
	 * 
	 * @return the Icon
	 */
	public abstract Icon getIcon();
	
	
	/**
	 * Set the recurrence status in the tab.
	 * 
	 * @param string the status
	 */
	public abstract void setRecurrenceStatus(String string);
}