package lu.tudor.santec.gecamed.agenda.gui;

import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import bizcal.common.Event;

/**
 * Printer Object to print out the Agenda Appointments with full information of the patient and the physician of
 * a appointment. 
 * 
 * @author Thorsten Roth thorsten.roth(at)tudor.lu
 *
 * @version
 * <br>$Log: AgendaReportField.java,v $
 * <br>Revision 1.2  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.1  2011-09-28 13:14:03  troth
 * <br>Rename class AgendaPrinterObject in AgendaReportField
 * <br>
 * <br>Revision 1.2  2011-09-14 12:20:34  troth
 * <br>Add the new function for printing a appointment overview for the physician.
 * <br>
 * <br>Revision 1.1  2011-09-02 14:11:55  troth
 * <br>Add the new agenda appointment printing for patient function.
 * <br>
 */
public class AgendaReportField
{
	Event 		event;
	Patient 	patient;
	Physician 	physician;
	
	public AgendaReportField(Event event, Patient patient, Physician physician)
	{
		this.event = event;
		this.patient = patient;
		this.physician  = physician;
	}

	public Event getBeanEvent() {
		return event;
	}

	public void setEvent(Event event) {
		this.event = event;
	}

	public Patient getBeanPatient() {
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
	}

	public Physician getBeanPhysician() {
		return physician;
	}

	public void setPhysician(Physician physician) {
		this.physician = physician;
	}
}