/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.ejb.entity.beans;

// Generated 15.03.2007 13:45:26 by Hibernate Tools 3.2.0.beta8

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


/**
 * Each Appointment must have an AppointmentType.<br/>
 * Each AppointmentType is linked to an AgendaCalendar. Exceptions see below.
 * 
 * A type is made of a name, a calendar, a color, an icon (only a string, icon is available in the client by 
 * this identifier), a duration and a class.
 * 
 * AppointmentTypes can be created by the settings of a calendar. To have a basic set of types that is shipped with
 * the software from which the user can assemble its own list.
 * To manage this, an AppointmentType has a class attribute of the types GENERAL, BACKGROUND, BLOCK_PERIOD.
 * There are three different situations where we use the types. 1. GENERAL the normal appointments for patients etc.
 * 2. so called BACKGROUND events. They are used for special things like holidays, or closingtimes of the office.
 * 3. BLOCK_PERIOD events mark timeslots in that are blocked for creating appointments in this time, e.G. lunch or vacations
 *
 * If an AppointmentType does not have a calendar, its is used as basic system type, from which the user
 * can assemble their own lists.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.03.2007
 * 15:17:38
 *
 *
 * @version
 * <br>$Log: AppointmentType.java,v $
 * <br>Revision 1.10  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.9  2007/08/29 07:54:24  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.8  2007/08/28 11:29:58  hermen
 * <br>do not delete appointment types, set them deprecated
 * <br>
 * <br>Revision 1.7  2007/08/23 08:15:24  hermen
 * <br>added calendarId to appointment_type
 * <br>
 * <br>Revision 1.2  2007/03/27 05:55:39  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */

@javax.persistence.NamedQueries
({
	@NamedQuery(name=AppointmentType.FIND_ALL_APPOINTMENT_TYPES,
			query="SELECT Object(o) FROM AppointmentType o WHERE deprecated = :deprecated ORDER BY id"),
	@NamedQuery(name=AppointmentType.FIND_ALL_GLOBAL_APPOINTMENT_TYPES,
			query="SELECT Object(o) FROM AppointmentType o WHERE o.calendarId IS NULL AND deprecated = :deprecated ORDER BY id"),
	@NamedQuery(name=AppointmentType.FIND_ALL_GLOBAL_APPOINTMENT_TYPES_BY_TYPE,
			query="SELECT Object(o) FROM AppointmentType o WHERE o.calendarId IS NULL AND o.appointmentTypeClass = :type AND deprecated = :deprecated ORDER BY id"),
	@NamedQuery(name=AppointmentType.FIND_ALL_APPOINTMENT_TYPES_BY_CALENDAR_ID,
			query="SELECT Object(o) FROM AppointmentType o WHERE o.calendarId = :calendarId AND deprecated = :deprecated ORDER BY id"),
	@NamedQuery(name=AppointmentType.FIND_ALL_APPOINTMENT_TYPES_BY_TYPE_AND_CALENDAR_ID,
			query="SELECT Object(o) FROM AppointmentType o WHERE o.appointmentTypeClass = :type AND o.calendarId = :calendarId AND deprecated = :deprecated ORDER BY id")
})


@Entity
@Table(name = "appointment_type", schema = "agenda")
public class AppointmentType extends GECAMedEntityBean implements java.io.Serializable {

	
	/**
	 *  
	 */
	public static final Integer GENERAL = 0;
	public static final Integer BACKGROUND = 1;
	public static final Integer BLOCK_PERIOD = 2;

	public static final String FIND_ALL_APPOINTMENT_TYPES = "findAllAppointmentTypes";
	public static final String FIND_ALL_GLOBAL_APPOINTMENT_TYPES = "findAllGlobalAppointmentTypes";
	public static final String FIND_ALL_GLOBAL_APPOINTMENT_TYPES_BY_TYPE = "findAllGlobalAppointmentTypesByType";
	public static final String FIND_ALL_APPOINTMENT_TYPES_BY_CALENDAR_ID = "findAllAppointmentTypesByCalendarId";
	public static final String FIND_ALL_APPOINTMENT_TYPES_BY_TYPE_AND_CALENDAR_ID = "findAllAppointmentTypesByTypeAndCalendarId";

	// Fields
	private static final long serialVersionUID = 1L;

	private String name;

	private Integer color;

	private String icon;
	
	private Integer appointmentTypeClass;
	
	private Integer duration = 0;
	
	private Integer calendarId;
	
	private boolean deprecated;

	// Constructors

	/** default constructor */
	public AppointmentType() {
	}

	// Property accessors
	@Column(name = "name", unique = false, nullable = false, insertable = true, updatable = true, length = 30)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "color", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getColor() {
		return this.color;
	}

	public void setColor(Integer color) {
		this.color = color;
	}

	@Column(name = "icon", unique = false, nullable = true, insertable = true, updatable = true, length = 20)
	public String getIcon() {
		return this.icon;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * @return the appointmentTypeClass
	 */
	@Column(name = "type_class", unique = false, nullable = false, insertable = true, updatable = true)
	public Integer getAppointmentTypeClass() {
		return appointmentTypeClass;
	}

	/**
	 * @param appointmentTypeClass the appointmentTypeClass to set
	 */
	public void setAppointmentTypeClass(Integer appointmentTypeClass) {
		this.appointmentTypeClass = appointmentTypeClass;
	}

	/**
	 * @return the duration
	 */
	@Column(name = "duration", unique = false, insertable = true, updatable = true)
	public Integer getDuration() {
		return duration;
	}

	/**
	 * @param duration the duration to set
	 */
	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	/**
	 * @return the calendarId
	 */
	@Column(name = "calendar_id", unique = false, insertable = true, updatable = true)
	public Integer getCalendarId() {
		return calendarId;
	}

	/**
	 * @param calendarId the calendarId to set
	 */
	public void setCalendarId(Integer calendarId) {
		this.calendarId = calendarId;
	}

	/**
	 * Marks if the type has been deleted. As old appointments still linked to deleted types
	 * we just set them deprecated
	 * 
	 * @return the deprecated
	 */
	@Column(name = "deprecated", unique = false, insertable = true, updatable = true)
	public boolean isDeprecated() {
		return deprecated;
	}

	/**
	 * @param deprecated the deprecated to set
	 */
	public void setDeprecated(boolean deprecated) {
		this.deprecated = deprecated;
	}

}
