/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.agenda.ejb.entity.beans;

// Generated 15.03.2007 13:45:26 by Hibernate Tools 3.2.0.beta8

import java.io.IOException;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.w3c.tools.codec.Base64Decoder;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;

/**
 * AgendaCalendar is a single calendar. It has a creator, creationdate, title
 * and optional a user and a physician it belongs to.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 15.03.2007
 * 15:22:47
 *
 *
 * @version
 * <br>$Log: AgendaCalendar.java,v $
 * <br>Revision 1.8  2011-10-20 15:04:28  troth
 * <br>1. add new functions of ticket #879
 * <br>2. fix ticket #904
 * <br>3. new bizcal lib
 * <br>
 * <br>Revision 1.7  2010-07-08 08:24:20  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-05-07 14:39:53  heinemann
 * <br>new waitingroom
 * <br>
 * <br>Revision 1.4  2008-01-18 16:09:05  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.3  2007/05/25 13:50:25  heinemann
 * <br>pres-weekend checkin
 * <br>
 * <br>Revision 1.2  2007/03/27 05:55:39  heinemann
 * <br>*** empty log message ***
 * <br>
 *
 */

@javax.persistence.NamedQueries
({
	@NamedQuery(name=AgendaCalendar.FIND_ALL_CALENDARS,
			query="SELECT Object(o) FROM AgendaCalendar o ORDER BY o.title"),
	@NamedQuery(name=AgendaCalendar.FIND_ALL_CALENDARS_BY_PHYSICIAN,
			query="SELECT Object(o) FROM AgendaCalendar o " +
					"WHERE o.physicianId = :physicianId  ORDER BY o.title"),
	@NamedQuery(name=AgendaCalendar.FIND_ALL_CALENDARS_BY_USER,
			query="SELECT Object(o) FROM AgendaCalendar o " +
					"WHERE o.userId = :userId  ORDER BY o.title")
})


@Entity
@Table(name = "calendar", schema = "agenda")
public class AgendaCalendar extends GECAMedEntityBean implements java.io.Serializable {

	private static final BASE64Encoder encoder = new BASE64Encoder();
	private static final BASE64Decoder decoder = new BASE64Decoder();
	
	public static final String FIND_ALL_CALENDARS = "findAllAgendaCalendars";
	public static final String FIND_ALL_CALENDARS_BY_PHYSICIAN = "findAllAgendaCalendarsByPhysician";
	public static final String FIND_ALL_CALENDARS_BY_USER = "findAllAgendaCalendarsByUser";

	// Fields

	private static final long serialVersionUID = 1L;

	private String title;

	private Integer userId;

	private Integer physicianId;

	private Date created;

	private Integer createdBy;

	private Integer color;
	
	private Boolean isBackground;
	
	private String doctenaLogin;

	private String doctenaPassword;
	
	private Date modified;
	
	private Integer modifiedBy;
	private Date doctenaLastSync;

	// Constructors

	/** default constructor */
	public AgendaCalendar() {
		// set the default value of is the Calendar a background Calendar
		this.setBackground(false);
	}

	// Property accessors

	@Column(name = "title", unique = false, nullable = true, insertable = true, updatable = true, length = 100)
	public String getTitle() {
		return this.title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "user_id", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getUserId() {
		return this.userId;
	}

	public void setUserId(Integer userId) {
		this.userId = userId;
	}

	@Column(name = "physician_id", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getPhysicianId() {
		return this.physicianId;
	}

	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}

	@Column(name = "created", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public Date getCreated() {
		return this.created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	@Column(name = "created_by", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}
	
	@Column(name="modified")
	public Date getModified() {
		return modified;
	}

	public void setModified(Date modified) {
		this.modified = modified;
	}

	@Column(name="modified_by")
	public Integer getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(Integer modifiedBy) {
		this.modifiedBy = modifiedBy;
	}


	@Column(name = "doctena_login")
	public String getDoctenaLogin() {
		return this.doctenaLogin;
	}
	
	public void setDoctenaLogin(String doctenaLogin) {
		this.doctenaLogin = doctenaLogin;
	}

	@Column(name = "doctena_password")
	public String getDoctenaPassword() {
		return this.doctenaPassword;
	}

	public void setDoctenaPassword(String doctenaPassword) {
		this.doctenaPassword = doctenaPassword;
	}

	@Transient
	public void setDoctenaPasswordClearText(String clear) {
		if (clear == null || clear.length() == 0) {
			setDoctenaPassword(clear);			
		} else {
			setDoctenaPassword(encoder.encode(clear.getBytes()));			
		}
	}
	
	@Transient
	public String getDoctenaPasswordClearText() throws IOException {
		if (getDoctenaPassword() == null || getDoctenaPassword().length() == 0)
			return getDoctenaPassword();
		else 
			return new String(decoder.decodeBuffer(getDoctenaPassword()));
	}

	@Column(name = "doctena_lastSync")
	public Date getDoctenaLastSync() {
		return doctenaLastSync;
	}
	
	public void setDoctenaLastSync(Date doctenaLastSync) {
		this.doctenaLastSync = doctenaLastSync;
	}
	
	/**
	 * @return the color
	 */
	@Column(name="color")
	public Integer getColor() {
		return color;
	}

	/**
	 * @param color the color to set
	 */
	public void setColor(Integer color) {
		this.color = color;
	}
	
	
	public String toString() {
		/* ================================================== */
		return ""+this.title;
		/* ================================================== */
	}
	
	@Column(name = "is_background", unique = false, nullable = false, insertable = true, updatable = true)
	public Boolean isBackground() {
		return this.isBackground;
	}

	public void setBackground(Boolean isBackground) {
		this.isBackground = isBackground;
	}
	
	@Override
	public int compareTo (GECAMedEntityBean o)
	{
		if (o != null && o instanceof AgendaCalendar)
		{
			int i = GECAMedUtils.compareTo(this.getTitle(), ((AgendaCalendar)o).getTitle());
			if (i != 0)
				return i;
		}
		return super.compareTo(o);
	}


}
