/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.vcard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.AddressbookModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.AutoCompletion;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class VCardImportDialog extends JDialog implements ActionListener {

    private static final long serialVersionUID = 1L;
    private JButton cancelButton;
    private JButton okButton;
    private JComboBox typeBox;
    private String type;
    private JLabel label;

    public VCardImportDialog() {
	super(MainFrame.getInstance(), true);
	setTitle(Translatrix.getTranslationString("Addressbook.importContact"));
	this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
	
	this.setLayout(new FormLayout(
		"2dlu, 80dlu, pref, 2dlu, 80dlu, 2dlu",
		"2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu"));
	
	CellConstraints cc = new CellConstraints();
	
	this.label = new JLabel();
	this.label.setIcon( IconFetcher.getIcon(AddressbookModule.class, AddressbookModule.ICON_IMPORT));
	
	this.add(label, cc.xyw(2,2,4));
	String[] arr = {
		""
	};
	this.label.setText(Translatrix.getTranslationString("Addressbook.importContactQuestion", arr));
	this.label.setVerticalAlignment(JLabel.TOP);
	this.label.setVerticalTextPosition(JLabel.TOP);
	
	this.add(new JLabel(Translatrix.getTranslationString("Addressbook.type")),cc.xyw(3, 4, 1));
	
        this.typeBox =  new JComboBox();
	AutoCompletion.enableWithFreeText(this.typeBox);
	this.add(this.typeBox, cc.xyw(5, 4, 1));
	
	this.cancelButton = new JButton(Translatrix.getTranslationString("core.cancel"));
	this.cancelButton.addActionListener(this);
	
	this.okButton = new JButton(Translatrix.getTranslationString("core.ok"));
	this.okButton.addActionListener(this);
	
	ButtonBarBuilder bb = new ButtonBarBuilder();
	bb.addGlue();
	bb.addGridded(okButton);
	bb.addRelatedGap();
	bb.addGridded(cancelButton);
	JPanel jp = bb.getPanel();
	jp.setOpaque(false);
	this.add(jp, cc.xyw(2, 6, 4));
	
	this.pack();
	
    }

    public void actionPerformed(ActionEvent e) {
	if (e.getSource().equals(this.cancelButton)) {
	    type = null;
	} else if (e.getSource().equals(this.okButton)) {
	    type = (String) typeBox.getSelectedItem();
	}
	this.setVisible(false);
    }
    
    public String showDialog(Collection<Contact> contact, String[] types) {
	String[] arr = {
		contact.size() + ""
	};
	this.label.setText(Translatrix.getTranslationString("Addressbook.importContactQuestion", arr));
	loadTypes(types);
	this.setLocationRelativeTo(MainFrame.getInstance());
	this.setVisible(true);
	return type;
    }
    
    
    private void loadTypes(String[] types) {
	this.typeBox.removeAllItems();
	for (int i = 0; i < types.length; i++) {
	    typeBox.addItem(types[i]);
	}
    }
    
}
