/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.Border;

public class TitledMatteBorder implements Border {

    private static final long serialVersionUID = 1L;
    
    private int borderHeight;

    private Color color;

    private String title;

    private Font font;
    
    public TitledMatteBorder(int height, String title, Color color) {
	this.borderHeight = height;
	this.color = color;
	this.title = title;
	this.font = new Font("Arial", Font.BOLD, borderHeight-2);
    }

    public Insets getBorderInsets(Component c) {
	return new Insets(borderHeight,0,0,0);
    }

    public boolean isBorderOpaque() {
	return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(color);
        g.fillRect(0, 0, width, this.borderHeight);
        g.setColor(Color.BLACK);
        g.setFont(font);
        g.drawString(this.title, 5,this.borderHeight-3);
    }
    
    public void setTitle(String title) {
	this.title = title;
    }

}
