/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui.contactpanels;

import java.awt.Component;
import java.util.List;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;


/**
 * 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: IContactDataPanel.java,v $
 * <br>Revision 1.2  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-04-30 12:18:38  hermen
 * <br>initial checkin of Addressbook module
 * <br>
 *
 */
public interface IContactDataPanel {

    /**
     * retrieves the filled contact object from the panel 
     * @param patient the contact object
     */
    public void getContact(Contact contact) ;
    
    /**
     * sets the contact object to the panel
     * @param contact the patient object
     * @param editable should the panel be editable
     */
    public void setContact(Contact contact, boolean editable) ;
    
    /**
     * @return
     */
    public List<Component> getComponentsForFocus();
    
	
}
