/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.addressbook.gui.list.ContactTablePanel;
import lu.tudor.santec.gecamed.addressbook.gui.list.IContactListener;
import lu.tudor.santec.gecamed.billing.gui.medpres.MedPres;
import lu.tudor.santec.gecamed.core.gui.GECAMedAction;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedMessage;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * GECAMEDModule that manages the Addressbook for external contacts 
 * such as physicians, laboratories, hospitals etc..
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: AddressbookModule.java,v $
 * <br>Revision 1.19  2010-08-12 08:01:47  hermen
 * <br>fixed #595: Full contact list reload after single contact modification
 * <br>
 * <br>Revision 1.18  2010-04-23 13:15:00  hermen
 * <br>small improvements
 * <br>
 * <br>Revision 1.17  2010-04-23 05:59:09  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.16  2009-10-08 09:23:48  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.15  2009-05-11 10:01:42  hermen
 * <br>reload type list if contact is added/edited
 * <br>
 * <br>Revision 1.14  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.13  2008-05-13 10:12:44  hermen
 * <br>updated searchdialog
 * <br>
 * <br>Revision 1.12  2008-05-13 09:51:25  hermen
 * <br>added contact search dialog
 * <br>
 * <br>Revision 1.11  2008-05-09 07:34:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2008-05-08 14:04:41  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.9  2008-05-07 13:25:23  hermen
 * <br>updated import
 * <br>
 * <br>Revision 1.8  2008-05-06 14:29:13  hermen
 * <br>updated javadoc
 * <br>
 *
 */
public class AddressbookModule extends GECAMedModule implements IContactListener {

    /**
     * The name of the module 
     */
    public static final String MODULE_NAME = "Addressbook";
    
	private static final long serialVersionUID = 1L;

	public static final String ICON_ADDRESSBOOK = "addressbook.png";
	public static final String ICON_EDIT_CONTACT = "edit_contact.png";
	public static final String ICON_ADD_CONTACT = "add_contact.png";
	public static final String ICON_DELETE_CONTACT = "delete_contact.png";
	public static final String ICON_PHONE = "phone.png";
	public static final String ICON_COMMENT = "comment.png";
	public static final String ICON_ADDRESS = "general.png";
	public static final String ICON_LANGUAGE = "language.png";
	public static final String ICON_IMPORT = "import.png";
	public static final String ICON_EXPORT_CONTACT = "export.png";

	
	private static ImageIcon moduleicon = IconFetcher.getIcon(AddressbookModule.class, ICON_ADDRESSBOOK);

	private static AddressbookModule instance; 

	private JPanel mainPanel;

	private ContactTablePanel contactTablePanel;

	private ContactSidebar contactSideBar;

	public AddressbookModule() {
		super(MODULE_NAME, moduleicon, new Color(80,139,255,100));
		
		instance = this;
		
		this.setOpaque(false);
		Translatrix.addBundle("lu.tudor.santec.gecamed.addressbook.gui.resources.WidgetResources");
		
		initComponents();
		
		contactTablePanel.reload();
	}
	
	/**
	 * initalize the components
	 */
	private void initComponents() {

//		this.mainPanel = new JPanel(new BorderLayout(5,5));
		this.mainPanel = new JPanel(new FormLayout("0dlu,16dlu,pref:grow,8dlu,fill:100dlu,10dlu","5dlu,center:35dlu,10dlu,fill:pref:grow,5dlu"));
		CellConstraints cc = new CellConstraints();
		
		
		this.mainPanel.setBorder(new EmptyBorder(5,5,5,5));
		this.mainPanel.setOpaque(false);

		this.contactTablePanel = new ContactTablePanel();
		this.contactTablePanel.setOpaque(false);
		
		this.contactSideBar = new ContactSidebar();
		this.contactTablePanel.addContactListener(this);
		/* ------------------------------------------------------- */
		// old
		/* ------------------------------------------------------- */
//		this.mainPanel.add(contactTablePanel);
//		this.mainPanel.add(contactSideBar, BorderLayout.EAST);
		/* ------------------------------------------------------- */
		// new
		/* ------------------------------------------------------- */
		this.mainPanel.add(this.contactTablePanel.getSearchComponent(), cc.xyw(2, 2, 2));
		this.mainPanel.add(contactTablePanel,                           cc.xy( 3, 4));
		this.mainPanel.add(contactSideBar,                              cc.xy( 5, 4));
		
		this.mainPanel.add(new JSeparator(), cc.xyw(3, 3, 1));
		/* ------------------------------------------------------- */
		
		this.setContentPanel(mainPanel);
		
		
		// add a new Contact
		GECAMedAction addContactAction = new GECAMedAction(this, "Addressbook.addContact", IconFetcher.getIcon(AddressbookModule.class, ICON_ADD_CONTACT), 0 ,false, true, false) {
			private static final long serialVersionUID = 1L;
			public void actionPerformed (ActionEvent p_Event)
		    {
			   contactTablePanel.newContact();
		    }
		};
		addContactAction.add();
		
		// import a new Contact
		GECAMedAction importContactAction = new GECAMedAction(this, "Addressbook.importContact", IconFetcher.getIcon(AddressbookModule.class, ICON_IMPORT), 0 ,false, true, false) {
			private static final long serialVersionUID = 1L;
			public void actionPerformed (ActionEvent p_Event)
		    {
				contactTablePanel.importContacts();
		    }
		};
		importContactAction.add();
		
		// action to reload the search
		GECAMedAction reloadAction = new GECAMedAction(this, "Addressbook.reload", GECAMedModule.getIcon(GECAMedIconNames.RELOAD), 0 ,false, true, false, KeyEvent.VK_F5) {
			private static final long serialVersionUID = 1L;
			public void actionPerformed (ActionEvent p_Event)
		    {
				contactTablePanel.reload();
		    }
		};
		reloadAction.add();
		
//		this.titlePanel.setHeaderComponent(this.contactTablePanel.getSearchComponent());
		
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.addressbook.gui.list.IContactListener#contactChanged(lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact)
	 */
	public void contactChanged(Contact contact) {
	    this.contactSideBar.setContact(contact);
	}
	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedModule#afterShowup()
	 */
	@Override
	public void afterShowup() {
		if (this.contactTablePanel != null )
			this.contactTablePanel.setFocus();
	}

	public void contactClicked(Contact contact) {
	    if (contactTablePanel.contactEditDialog.showDialog(contact)) {
		 contact = contactTablePanel.contactEditDialog.getContact();
		 contactTablePanel.addressManager.saveContact(contact);
		 MainFrame.fireGECAMedMessage (new GECAMedMessage(AddressbookModule.getInstance(), MedPres.MEDPRES_CHANGED, null, null));
		 contactTablePanel.fillTypeBox();
		 contactTablePanel.updateContact(contact);
		 contactChanged(contact);
		 
//		 contactTablePanel.reload();
	    }
	}
	
	public static AddressbookModule getInstance() {
	    return instance;
	}
	
}
