/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.addressbook.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.Title;

/**
 * Entity Bean that maps the <b>addressbook.contact</b> table
 * which stores contact persons
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: Contact.java,v $
 * <br>Revision 1.11  2011-04-26 08:37:03  ferring
 * <br>just format changed
 * <br>
 * <br>Revision 1.10  2010-05-18 13:37:41  gbosch
 * <br>changed address sorting
 * <br>
 * <br>Revision 1.9  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * <br>Revision 1.8  2009-01-13 09:15:42  hermen
 * <br>reload addresses/zips after import bug id 209
 * <br>
 * <br>Revision 1.7  2008-12-18 13:04:15  mack
 * <br>Changes required for coherent name representation.
 * <br>
 * <br>Revision 1.6  2008-12-12 13:42:56  hermen
 * <br>changed formatting of contact address
 * <br>
 * <br>Revision 1.5  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-05-08 09:02:17  hermen
 * <br>changed formatting
 * <br>
 * <br>Revision 1.3  2008-04-30 12:28:14  hermen
 * <br>updated formatting
 * <br>
 * <br>Revision 1.2  2008-04-30 12:18:38  hermen
 * <br>initial checkin of Addressbook module
 * <br>
 * <br>Revision 1.1  2008-04-29 09:14:40  hermen
 * <br>initial checkin of addressbook module
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
	@javax.persistence.NamedQuery(name="findAllContact",
		    query="SELECT OBJECT(o) FROM Contact o ORDER BY o.id ASC")
})

@Entity
@Table(name = "contact", schema = "addressbook")
public class Contact extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final String UCM_DEFAULT = "000000-00";
	
	private String nameFirst;
	private String name;
	private String title;
	private String nationality;
	private String language;
	private Date birthDate;
	private String email;
	private String phonePrivate;
	private String phoneWork;
	private String phoneMobile;
	private String fax;
	private String ucmCode;
	private String contactType;
	private String comment;
	private String medpres;
	
	private Set<ContactAddress> address;
	
	public Contact() {
	    this.ucmCode = UCM_DEFAULT;
	}
	
	/**
	 * @return Returns the email.
	 */
	@javax.persistence.Column(name = "email")
	public String getEmail() {
		return email;
	}

	/**
	 * @param email The email to set.
	 */
	public void setEmail(String email) {
		this.email = email;
	}
	
	
	/**
	 * @return the birthDate
	 */
	@javax.persistence.Column(name = "birth_date")
	public Date getBirthDate() {
	    return birthDate;
	}

	/**
	 * @param birthDate the birthDate to set
	 */
	public void setBirthDate(Date birthDate) {
	    this.birthDate = birthDate;
	}

	/**
	 * @return the contactType
	 */
	@javax.persistence.Column(name = "contact_type")
	public String getContactType() {
	    return contactType;
	}

	/**
	 * @param contactType the contactType to set
	 */
	public void setContactType(String contactType) {
	    this.contactType = contactType;
	}

	/**
	 * @return the language
	 */
	@javax.persistence.Column(name = "language")
	public String getLanguage() {
	    return language;
	}

	/**
	 * @param language the language to set
	 */
	public void setLanguage(String language) {
	    this.language = language;
	}

	/**
	 * @return the name
	 */
	@javax.persistence.Column(name = "name")
	public String getName() {
	    return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
	    this.name = name;
	}

	/**
	 * @return the nameFirst
	 */
	@javax.persistence.Column(name = "name_first")
	public String getNameFirst() {
	    return nameFirst;
	}

	/**
	 * @param nameFirst the nameFirst to set
	 */
	public void setNameFirst(String nameFirst) {
	    this.nameFirst = nameFirst;
	}

	/**
	 * @return the nationality
	 */
	@javax.persistence.Column(name = "nationality")
	public String getNationality() {
	    return nationality;
	}

	/**
	 * @param nationality the nationality to set
	 */
	public void setNationality(String nationality) {
	    this.nationality = nationality;
	}

	/**
	 * @return the phoneMobile
	 */
	@javax.persistence.Column(name = "phone_mobile")
	public String getPhoneMobile() {
	    return phoneMobile;
	}

	/**
	 * @param phoneMobile the phoneMobile to set
	 */
	public void setPhoneMobile(String phoneMobile) {
	    this.phoneMobile = phoneMobile;
	}

	/**
	 * @return the phonePrivate
	 */
	@javax.persistence.Column(name = "phone_private")
	public String getPhonePrivate() {
	    return phonePrivate;
	}

	/**
	 * @param phonePrivate the phonePrivate to set
	 */
	public void setPhonePrivate(String phonePrivate) {
	    this.phonePrivate = phonePrivate;
	}

	/**
	 * @return the phoneWork
	 */
	@javax.persistence.Column(name = "phone_work")
	public String getPhoneWork() {
	    return phoneWork;
	}

	/**
	 * @param phoneWork the phoneWork to set
	 */
	public void setPhoneWork(String phoneWork) {
	    this.phoneWork = phoneWork;
	}

	/**
	 * @return the title
	 */
	@javax.persistence.Column(name = "title")
	public String getTitle() {
	    return title;
	}

	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
	    this.title = title;
	}
	

	/**
	 * @return the ucmCode
	 */
	@javax.persistence.Column(name = "ucm_code")
	public String getUcmCode() {
	    return ucmCode;
	}

	/**
	 * @param ucmCode the ucmCode to set
	 */
	public void setUcmCode(String ucmCode) {
	    this.ucmCode = ucmCode;
	}
	
	/**
	 * @return the comment
	 */
	@javax.persistence.Column(name = "comment")
	public String getComment() {
	    return comment;
	}

	/**
	 * @param comment the comment to set
	 */
	public void setComment(String comment) {
	    this.comment = comment;
	}

	/**
	 * @return the fax
	 */
	@javax.persistence.Column(name = "fax")
	public String getFax() {
	    return fax;
	}

	/**
	 * @param fax the fax to set
	 */
	public void setFax(String fax) {
	    this.fax = fax;
	}

	/**
	 * @return the medpres
	 */
	@javax.persistence.Column(name = "medpres")
	public String getMedpres() {
	    return medpres;
	}

	/**
	 * @param medpres the medpres to set
	 */
	public void setMedpres(String medpres) {
	    this.medpres = medpres;
	}
	
	/**
	 * @return Returns the ContactAddresss.
	 */
	@OneToMany(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "contact_id")
	@OrderBy("date DESC")
	public Set<ContactAddress> getAddress() {
		return address;
	}
	
	/**
	 * returns the first contact address
	 * @return the first contact address
	 */
	@Transient
	public ContactAddress getContactAddress() {
	    Set<ContactAddress> addresses = getAddress();
	    if (addresses == null || addresses.size() == 0) 
		return null;
	    
	    return addresses.iterator().next();
	}

	/**
	 * @param ContactAddress
	 *            The ContactAddresss to set.
	 */
	public void setAddress(Set<ContactAddress> address) {
		this.address = address;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer rendered;
		
		rendered = new StringBuffer();
		if (this.getTitle() != null)		rendered.append(getTitle()).append(" ");   		
		if (this.getName() != null && !"".equals(this.getName()))	rendered.append(getName()).append(" ");   		
		if (this.getNameFirst() != null)		rendered.append(getNameFirst());   		
		return rendered.toString();
	}

	public String toNameString() {
	    StringBuffer sb = new StringBuffer();
	    
	    sb.append(Title.translate(getTitle())).append (" ");

	    if (getNameFirst() != null && ! getNameFirst().equals(""))
	    	sb.append(getNameFirst()).append(" ");
	    sb.append(getName());
	   
	    return sb.toString();
	}

	public String toPhoneString() {
	    StringBuffer sb = new StringBuffer();
	    if (getPhoneWork() != null && ! getPhoneWork().equals("")) {
		sb.append("w: " + getPhoneWork());
	    }
	    if (getPhonePrivate() != null && ! getPhonePrivate().equals("")) {
		if (sb.length() != 0)
		    sb.append("\n");
		sb.append("p: " + getPhonePrivate());
	    }
	    return sb.toString();
	}

	public String toAddressString() {
	    StringBuffer sb = new StringBuffer();
	    if (address != null) {
		    int i = 1;
        	    for (Iterator<ContactAddress> iter = address.iterator(); iter.hasNext();) {
        		ContactAddress address = (ContactAddress) iter.next();
        		if (sb.length() != 0)
        		    sb.append("\n");
        		sb.append(address.toString());
        		if (i==2)
        		    break;
        		i++;
        	    }
	    }
	    return sb.toString();
	}
}

