/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;

public class LocalityListModel  implements ListModel {

    private ArrayList<Locality> localities = new ArrayList<Locality>();
    private Vector<ListDataListener> listeners = new Vector<ListDataListener>();

    public void addListDataListener(ListDataListener l) {
	this.listeners.add(l);
    }

    public Object getElementAt(int index) {
    	if (index < localities.size())
    		 return localities.get(index);
    	else return null;
    }

    public int getSize() {
	return localities.size();
    }

    public void removeListDataListener(ListDataListener l) {
	this.listeners.remove(l);
    }

    public void setLocalities(Collection<Locality> localities) {
	this.localities  = new ArrayList<Locality>(localities);
	for (Iterator iter = listeners.iterator(); iter.hasNext();) {
	    ListDataListener listener = (ListDataListener) iter.next();
	    listener.contentsChanged(new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, 0, localities.size()));
	}
    }

}
