package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.IntegerField;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author hermenj
 *
 * @version
 * <br>$Log: LocalityEditDialog.java,v $
 */
public class ZipEditDialog extends GECAMedBaseDialog {

	private static final long serialVersionUID = 1L;
	private JLabel m_IDLabel;
	private JTextField m_StreetField;
	private JComboBox<Locality> m_Locality;
	private Zip m_zip;
	private IntegerField m_ZipField;
	private IntegerField m_FirstField;
	private IntegerField m_LastField;
	private JComboBox<Character> m_Parity;

	public ZipEditDialog(JFrame parent) {
		super(parent, Translatrix.getTranslationString("ZipEditDialog.title"), true);
		
		JPanel mainPanel = new JPanel(new FormLayout(
				"2dlu, left:pref, 2dlu, fill:150dlu:grow, 2dlu",
				"2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu"
			));
		mainPanel.setOpaque(false);
		CellConstraints cc = new CellConstraints();
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_IDHeader)), cc.xy(2,2));
		m_IDLabel = new JLabel();
		mainPanel.add(m_IDLabel, cc.xy(4,2));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_ZIPHeader)), cc.xy(2,4));
		m_ZipField = new IntegerField();
		mainPanel.add(m_ZipField, cc.xy(4,4));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_StreetNameHeader)), cc.xy(2,6));
		m_StreetField = new JTextField(40);
		mainPanel.add(m_StreetField, cc.xy(4,6));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_LocalityNameHeader)), cc.xy(2,8));
		
		Locality[] locs = GECAMedLists.getArray(Locality.class);
		Arrays.sort(locs, new Comparator<Locality>(){
			public int compare(Locality o1, Locality o2) {
				try {
					return o1.getName().compareTo(o2.getName());				
				} catch (Exception e) {
					return 0;
				}
			}
		});
		m_Locality = new JComboBox<Locality>(locs);
		mainPanel.add(m_Locality, cc.xy(4,8));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_ParityHeader)), cc.xy(2,10));
		
		m_Parity = new JComboBox<Character>(new Character[] {'N','O','E'});
		m_Parity.setRenderer(new OddEvenRenderer());
		mainPanel.add(m_Parity, cc.xy(4,10));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_FirstHeader)), cc.xy(2,12));
		m_FirstField = new IntegerField();
		mainPanel.add(m_FirstField, cc.xy(4,12));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(ZIPListModel.c_LastHeader)), cc.xy(2,14));
		m_LastField = new IntegerField();
		mainPanel.add(m_LastField, cc.xy(4,14));
		
		this.addMainPanel(mainPanel);
		this.pack();
		
	}

	public Integer editZip(Zip l) {
		m_Locality.removeAllItems();
		Locality[] locs = GECAMedLists.getArray(Locality.class);
		Arrays.sort(locs, new Comparator<Locality>(){
			public int compare(Locality o1, Locality o2) {
				try {
					return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());				
				} catch (Exception e) {
					return 0;
				}
			}
		});
		for (Locality locality : locs) {			
			m_Locality.addItem(locality);
		}
		
		try {
			m_zip = l;
			if (l.getId() != null) {
				m_IDLabel.setText(l.getId()+"");				
			} else {
				m_IDLabel.setText("-");
			}
			
			if (l.getStreet() != null) {
				m_StreetField.setText(l.getStreet());				
			} else {
				m_StreetField.setText("");
			}
			
			if (l.getZip() != null) {
				m_ZipField.setValue(l.getZip());
			} else {
				m_ZipField.setText("");
			}
			
			try {
				Locality m = GECAMedLists.getIdMapReference(Locality.class).get(l.getLocalityId());
				m_Locality.setSelectedItem(m);					
			} catch (Exception e) {}
			
			try {
				m_Parity.setSelectedItem(l.getParity());				
			} catch (Exception e) {}

			if (l.getFirst() != null) {
				m_FirstField.setValue(l.getFirst());				
			} else {
				m_FirstField.setText("");
			}
			
			if (l.getLast() != null) {
				m_LastField.setValue(l.getLast());				
			} else {
				m_LastField.setText("");
			}
			
			return showCenteredDialog();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return JOptionPane.CANCEL_OPTION;
	}
	
	
	public Zip getZip() {
		m_zip.setStreet(m_StreetField.getText());
		m_zip.setZip(m_ZipField.getValue());
		
		m_zip.setLocalityId(((Locality)m_Locality.getSelectedItem()).getId());
		
		m_zip.setParity((Character) m_Parity.getSelectedItem());
		
		Integer first = m_FirstField.getValue();
		if (first == 0) first = null;
		m_zip.setFirst(first);
		Integer last = m_LastField.getValue();
		if (last == 0) last = null;
		m_zip.setLast(last);
		
		return m_zip;
	}
	
	class OddEvenRenderer extends DefaultListCellRenderer {
		private static final long serialVersionUID = 1L;
		
		public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
			JLabel l = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
			l.setText(Translatrix.getTranslationString("ZipEditDialog."+value));
			return l;
		}
	}
}
