/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import java.util.Collection;
import java.util.Set;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericListBox;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class ZIPListBox extends GenericListBox 
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ZIPListModel	m_LocalityZIPs;
	private ZIPListRenderer	m_Renderer;
	
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public ZIPListBox ()
    {	
	super (new ZIPListModel ());
    
	m_LocalityZIPs = (ZIPListModel) this.getTableModel();
	m_Renderer = new ZIPListRenderer ();
	this.setRenderer(m_Renderer);
    }

//***************************************************************************
//* Class Body		                                                    	*	
//***************************************************************************

//---------------------------------------------------------------------------

public void removeAllZIPs ()
	{
	m_LocalityZIPs.removeAll();
	}

//---------------------------------------------------------------------------

public void setZIPs (Collection<Zip> p_Stubs)
	{
	m_LocalityZIPs.setZIPs (p_Stubs);
	this.packColumns();
	}    
	 
//---------------------------------------------------------------------------

public Set <Zip> getZIPs ()
	{
	return m_LocalityZIPs.getZIPs();
	}    

public Zip getSelectedZip() {
	return m_LocalityZIPs.getZIPAt(getSelectedRow());
}   
	    
//***************************************************************************
//* End of Class															*
//***************************************************************************
  
   }
