/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Municipality;
import lu.tudor.santec.gecamed.billing.gui.GenericListRenderer;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.utils.TableSorter;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************
public class LocalityListRenderer extends GenericListRenderer
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private LocalityListModel		m_TableModel;
	private	TableSorter					m_InvoiceSorter;
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public LocalityListRenderer ()
	{
	super();

	}

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

private int modelRow (int p_ViewRow)
	{
	int	l_ModelRow;
	
	l_ModelRow = p_ViewRow;
	
	if ((m_InvoiceSorter != null) && m_InvoiceSorter.isSorting())
		{
		l_ModelRow = m_InvoiceSorter.modelIndex(l_ModelRow);
		}
	
	return l_ModelRow;
	}

//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column) 
	{
	Component 		l_Component;
	int				l_Column;
	int				l_Row;
	Locality		l_Stub;
	
	l_Component = super.getTableCellRendererComponent(p_Table, p_Value, p_IsSelected, p_HasFocus, p_Row, p_Column);
	l_Stub		= null;
	
	if (m_TableModel == null) 
		{
		m_InvoiceSorter = (TableSorter) p_Table.getModel();
		m_TableModel 	= (LocalityListModel) m_InvoiceSorter.getTableModel();
		}
	
	if (m_TableModel != null)  //&& (p_Row != m_LastRow))
		{
		l_Row = this.modelRow (p_Row);
		l_Stub = m_TableModel.getLocalityAt(l_Row);
		}
	
	if ((p_Value != null) && (l_Stub != null))
		{
		l_Column = this.modelColumn(p_Table, p_Column);
		
		switch (l_Column)
			{
			case LocalityListModel.c_MunicipalityColumn :
				
				m_Label.setText(getMunicipalityName(l_Stub.getMunicipalityId()));
				m_Label.setHorizontalAlignment(JLabel.LEFT);
				break;
			
			case LocalityListModel.c_IDColumn: 
				m_Label.setText(p_Value+"");
				m_Label.setHorizontalAlignment(JLabel.CENTER);
				break;
				
			default: 
				m_Label.setText(p_Value+"");
				m_Label.setHorizontalAlignment(JLabel.LEFT);
			}
		}	
	return m_Label;
	}

private String getMunicipalityName(Integer municipalityId) {
	return ((Municipality)GECAMedLists.getIdMapReference(Municipality.class).get(municipalityId)).getName();
}



	
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
