/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * InvoiceListModel.java
 *
 * Created on March 31, 2006
 */

package lu.tudor.santec.gecamed.address.gui.addressmanagement;

/**
 *
 * @author  santec
 */


import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.i18n.Translatrix;

//***************************************************************************
//* Class Members                                                           *
//***************************************************************************

public class LocalityListModel extends AbstractTableModel
    {
 	private static final long serialVersionUID = 1L;
  	
    private Vector      	<Locality> m_Localitys;        
    
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
    
    public static final String c_IDHeader 				= "LocalityStubListModel.IDHeader";
    public static final String c_LocalityNameHeader		= "LocalityStubListModel.LocalityNameHeader";
    public static final String c_LocalityNameLUHeader	= "LocalityStubListModel.LocalityNameLUHeader";
    public static final String c_MunicipalityHeader 	= "LocalityStubListModel.MunicipalityHeader";
          
    public static final int    c_IDColumn 				= 0;
    public static final int    c_LocalityNameColumn		= 1;
    public static final int    c_LocalityNameLUColumn	= 2;
    public static final int    c_MunicipalityColumn		= 3; 
    
    static final public String c_TableHeaders [] = { 	c_IDHeader,
    													c_LocalityNameHeader,
    													c_LocalityNameLUHeader,
    	 												c_MunicipalityHeader,
    	 												};
 
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public LocalityListModel ()
    {
	m_Localitys	= new Vector <Locality> ();
    }

//***************************************************************************
//* Class Primitives		                                                *
//***************************************************************************

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public String getColumnName (int p_Column)
    {
    if ((p_Column >=0) && (p_Column < c_TableHeaders.length))
    		{
    		return (Translatrix.getTranslationString(c_TableHeaders[p_Column]));
    		}
    else return ("");
    }

//---------------------------------------------------------------------------

public int getColumnCount ()
    {
    return (c_TableHeaders.length);
    }

//---------------------------------------------------------------------------

public int getRowCount ()
    {
    return (m_Localitys.size());
    }

//---------------------------------------------------------------------------

public Object getValueAt (int p_Row, int p_Column)
    {
    Locality	l_LocalityStub = null;
  
    if ((p_Row >= 0) && (p_Row < m_Localitys.size()))
        {
    	l_LocalityStub  = m_Localitys.elementAt (p_Row);
         }
	 
	if (l_LocalityStub == null) l_LocalityStub = new Locality ();

	switch (p_Column)
        {
        case  c_IDColumn:    			return l_LocalityStub.getId();  
        case  c_LocalityNameColumn: 	return (l_LocalityStub.getName() != null) ? (l_LocalityStub.getName()) : "";    
        case  c_LocalityNameLUColumn: 	return (l_LocalityStub.getLuxembourgishName() != null) ? (l_LocalityStub.getLuxembourgishName()) : ""; 
        case  c_MunicipalityColumn: 	return (l_LocalityStub.getMunicipalityId() != null) ? (l_LocalityStub.getMunicipalityId()) : 0;               
        default: return "";
        }
    }
//---------------------------------------------------------------------------

public Class getColumnClass (int p_Column) 
    {
    if (getValueAt(0, p_Column) != null)
    		 return (Class) getValueAt(0, p_Column).getClass();
    else return null;
    }

//---------------------------------------------------------------------------
/**
 * queries the ability to be edited of the cell specified by p_Row and p_Column
 * @param p_Row specifies the row to be queried
 * @param p_Column specifies the column to be queried
 * @return <CODE>true</CODE> if the specified cell is editable, <CODE>false</CODE> otherwise
 */
//---------------------------------------------------------------------------

public boolean isCellEditable   (int p_Row, int p_Column)
    {
    return false;
    }
 
//---------------------------------------------------------------------------

public Locality	getLocalityAt (int p_Row)
    {
	Locality  l_Stub;
     
    if ((p_Row >= 0) && (p_Row < m_Localitys.size()))
        {
    	l_Stub = m_Localitys.elementAt (p_Row);
        return l_Stub;
        }
    else return null;
    }
	
//---------------------------------------------------------------------------

public void addLocality (Locality p_Stub)
    {
    int	l_Row;
	
	if (p_Stub != null)    
        {    
		m_Localitys.addElement (p_Stub);
    		
		l_Row = m_Localitys.size() - 1;
		
    	fireTableRowsInserted (l_Row,l_Row);
        }
    }
	
//---------------------------------------------------------------------------

public void removeAll ()
	{
	int	l_LastRow;
	
	l_LastRow = m_Localitys.size() -1;
	
	m_Localitys.removeAllElements ();
	
	if (l_LastRow >= 0) fireTableRowsDeleted (0,l_LastRow);
	}


//---------------------------------------------------------------------------

public void setLocalitys (Set <Locality> p_Stubs)
    {
     if (p_Stubs == null) return;
        
    removeAll ();
    m_Localitys.addAll (p_Stubs);
    fireTableRowsInserted (0,m_Localitys.size());
    }

//---------------------------------------------------------------------------

public Set <Locality> getLocalitys ()
    {
	HashSet <Locality> l_Stubs;
	
	l_Stubs = new HashSet <Locality> (m_Localitys);
	
	return l_Stubs;
	}    
        
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
