/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import java.util.Set;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericListBox;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class LocalityListBox extends GenericListBox 
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private LocalityListModel		m_Localitys;
	private LocalityListRenderer 	m_Renderer;
	
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public LocalityListBox ()
    {	
	super (new LocalityListModel ());
    
	m_Localitys = (LocalityListModel) this.getTableModel();
	m_Renderer = new LocalityListRenderer ();
	this.setRenderer(m_Renderer);
    }

//***************************************************************************
//* Class Body		                                                    	*	
//***************************************************************************

//---------------------------------------------------------------------------

public void removeAllLocalitys ()
	{
	m_Localitys.removeAll();
	}

//---------------------------------------------------------------------------

public void setLocalitys (Set <Locality> p_Stubs)
	{
	m_Localitys.setLocalitys (p_Stubs);
	this.packColumns();
	}    
	 
//---------------------------------------------------------------------------

public Set <Locality> getLocalitys ()
	{
	return m_Localitys.getLocalitys();
	}

public Locality getSelectedLocality() {
	return m_Localitys.getLocalityAt(getSelectedRow());
}    
	    
//***************************************************************************
//* End of Class															*
//***************************************************************************
  
   }
