package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import java.util.Arrays;
import java.util.Comparator;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Municipality;
import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author hermenj
 *
 * @version
 * <br>$Log: LocalityEditDialog.java,v $
 */
public class LocalityEditDialog extends GECAMedBaseDialog {

	private static final long serialVersionUID = 1L;
	private JLabel m_IDLabel;
	private JTextField m_NameField;
	private JTextField m_NameFieldLU;
	private JComboBox<Municipality> m_Municipality;
	private Locality m_locality;

	public LocalityEditDialog(JFrame parent) {
		super(parent, Translatrix.getTranslationString("LocalityEditDialog.title"), true);
		
		JPanel mainPanel = new JPanel(new FormLayout(
				"2dlu, left:pref, 2dlu, fill:150dlu:grow, 2dlu",
				"2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu"
			));
		mainPanel.setOpaque(false);
		CellConstraints cc = new CellConstraints();
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(LocalityListModel.c_IDHeader)), cc.xy(2,2));
		m_IDLabel = new JLabel();
		mainPanel.add(m_IDLabel, cc.xy(4,2));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(LocalityListModel.c_LocalityNameHeader)), cc.xy(2,4));
		m_NameField = new JTextField(40);
		mainPanel.add(m_NameField, cc.xy(4,4));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(LocalityListModel.c_LocalityNameLUHeader)), cc.xy(2,6));
		m_NameFieldLU = new JTextField(40);
		mainPanel.add(m_NameFieldLU, cc.xy(4,6));
		
		mainPanel.add(new JLabel(Translatrix.getTranslationString(LocalityListModel.c_MunicipalityHeader)), cc.xy(2,8));
		
		Municipality[] muns = GECAMedLists.getArray(Municipality.class);
		Arrays.sort(muns, new Comparator<Municipality>(){
			public int compare(Municipality o1, Municipality o2) {
				try {
					return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());				
				} catch (Exception e) {
					return 0;
				}
			}
		});
		m_Municipality = new JComboBox<Municipality>(muns);
		mainPanel.add(m_Municipality, cc.xy(4,8));
		
		this.addMainPanel(mainPanel);
		this.pack();
		
	}

	public Integer editLocality(Locality l) {
		try {
			m_locality = l;
			if (l.getId() != null) {
				m_IDLabel.setText(l.getId()+"");				
			} else {
				m_IDLabel.setText("-");
				
			}
			m_NameField.setText(l.getName());
			m_NameFieldLU.setText(l.getLuxembourgishName());
			
			try {
				Municipality m = GECAMedLists.getIdMapReference(Municipality.class).get(l.getMunicipalityId());
				m_Municipality.setSelectedItem(m);					
			} catch (Exception e) {}
			
			return showCenteredDialog();
		} catch (Exception e) {
		}
		return JOptionPane.CANCEL_OPTION;
	}
	
	
	public Locality getLocality() {
		m_locality.setName(m_NameField.getText());
		m_locality.setLuxembourgishName(m_NameFieldLU.getText());
		m_locality.setMunicipalityId(((Municipality)m_Municipality.getSelectedItem()).getId());
		return m_locality;
	}
	

}
