/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.gui.addressmanagement;

import lu.tudor.santec.gecamed.core.gui.widgets.progress.ProgressEvent;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

public class ImportProgress extends ProgressEvent
	{
	private long	m_LineNumber;
	private String	m_Message;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

public 	ImportProgress (Object p_Source, long p_LineNumber)
	{
	super (p_Source,ProgressEvent.c_Progressed);
	this.setLineNumber (p_LineNumber);
	}

//---------------------------------------------------------------------------

public 	ImportProgress (Object p_Source, String p_Message)
	{
	super (p_Source,ProgressEvent.c_Progressed);
	this.setMessage (p_Message);
	}

//---------------------------------------------------------------------------

public 	ImportProgress (Object p_Source, long p_LineNumber, String p_Message)
	{
	super (p_Source,ProgressEvent.c_Progressed);
	this.setLineNumber (p_LineNumber);
	this.setMessage (p_Message);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void setLineNumber (long p_LineNumber)
	{
	m_LineNumber = p_LineNumber;
	}

//---------------------------------------------------------------------------

public long getLineNumber ()
	{
	return m_LineNumber;
	}

//---------------------------------------------------------------------------

public void setMessage (String p_Message)
	{
	m_Message = p_Message;
	}

//---------------------------------------------------------------------------

public String getMessage ()
	{
	return m_Message;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class		                                                    *
//***************************************************************************
//---------------------------------------------------------------------------

}
