/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.ejb.session.beans;

import java.util.Collection;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.Locality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Municipality;
import lu.tudor.santec.gecamed.address.ejb.entity.beans.Zip;
import lu.tudor.santec.gecamed.address.ejb.session.interfaces.AddressImportInterface;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Stateless
@Remote (AddressImportInterface.class)
public class AddressImportBean implements AddressImportInterface
	{
	private static final long serialVersionUID = 1L;
	
	@PersistenceContext (unitName="gecam")
	EntityManager m_EntityManager;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection <Locality> 	getAllLocalities () 	throws Exception
	{
	Collection l_Localities;
	
	l_Localities = m_EntityManager.createNamedQuery ("findAllLocality")
	   							  .getResultList();
	
	return l_Localities;
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection <Municipality> 	getAllMunicipalities () 	throws Exception
	{
	Collection l_Municipalities;
	
	l_Municipalities = m_EntityManager.createNamedQuery (Municipality.c_GetAllMunicipalites)
	   							      .getResultList();
	
	return l_Municipalities;
	}
	
//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection <Zip> 	getAllZips () 	throws Exception
	{
	Collection l_Zips;
	
	l_Zips = m_EntityManager.createNamedQuery ("findAllZip")
	   					    .getResultList();
	
	return l_Zips;
	}

//---------------------------------------------------------------------------

public void deleteZip (Zip p_Zip) throws Exception
	{
	if ((p_Zip != null) && (p_Zip.isPersistent()))
		{
		p_Zip = m_EntityManager.find (Zip.class, p_Zip.getId());
		if (p_Zip != null) m_EntityManager.remove(p_Zip);
		}
	}

//---------------------------------------------------------------------------

public Locality saveLocality (Locality p_Locality) throws Exception
	{
	return m_EntityManager.merge(p_Locality);
	}

//---------------------------------------------------------------------------

public Municipality saveMunicipality (Municipality p_Municipality) throws Exception
	{
	return m_EntityManager.merge(p_Municipality);
	}

//---------------------------------------------------------------------------

public Zip saveZip (Zip p_Zip) throws Exception
	{
	return m_EntityManager.merge(p_Zip);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
}
