/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>address.municipality</b> table
 * which stores a list of all available municipalities for luxembourg
 * 
 * Author: Nico  MACK Tudor/Santec
 *
 * @Version
 * <br>$Log$
 * <br>Revision 1.4  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007-12-12 15:10:23  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "municipality", schema = "address")

@NamedQueries 
	({
		@NamedQuery(name = Municipality.c_GetAllMunicipalites, query = "SELECT OBJECT(o) FROM Municipality o"),
		@NamedQuery(name = Municipality.c_MunicipalityByName,  query = "SELECT OBJECT(o) FROM Municipality o WHERE o.name = :name")
	})

public class Municipality extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private Integer m_CantonId;
	private String 	m_Name;
	private String  m_LuxembourgishName;

	public static final String c_GetAllMunicipalites = "getAllMunicipalities";
	public static final String c_MunicipalityByName  = "getMunicipalityByName";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	
//---------------------------------------------------------------------------
	
@Column(name = "canton_id")
public Integer getCantonId() 
	{
	return m_CantonId;
	}

//---------------------------------------------------------------------------

public void setCantonId (Integer p_CantonId) 
	{
	m_CantonId = p_CantonId;
	}

//---------------------------------------------------------------------------

@Column(name = "name")
public String getName() 
	{
	return m_Name;
	}

//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	m_Name = p_Name;
	}

//---------------------------------------------------------------------------

@Column(name = "name_lu")
public String getLuxembourgishName() 
	{
	return m_LuxembourgishName;
	}

//---------------------------------------------------------------------------

public void setLuxembourgishName (String p_LuxembourgishName) 
	{
	m_LuxembourgishName = p_LuxembourgishName;
	}

//---------------------------------------------------------------------------
	
public String toString() 
	{
    return this.getName();
    }  

//---------------------------------------------------------------------------
//***************************************************************************
//* End of class	                                              			*
//***************************************************************************	
//---------------------------------------------------------------------------
       
}
