/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>address.locality</b> table
 * which stores a list of all available localities for luxembourg
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: Locality.java,v $
 * <br>Revision 1.7  2013-03-26 11:20:47  troth
 * <br>Fix Ticket #806.
 * <br>
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-06-30 08:16:45  hermen
 * <br>added address autocompletion by locality
 * <br>
 * <br>Revision 1.4  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.3  2007-12-12 15:10:23  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllLocality",
        query="SELECT OBJECT(o) FROM Locality o"),
    @javax.persistence.NamedQuery(name="findAllLocalityByName",
        query="SELECT OBJECT(o) FROM Locality o WHERE upper(o.name) LIKE upper(:name) OR upper(o.luxembourgishName) LIKE upper(:name)")
})

@Entity
@Table(name="locality", schema="address")
public class Locality extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;

	private Integer municipalityId;
	private String name;
	private String luxembourgishName;

	/**
	 * @return Returns the localityId.
	 */
	@javax.persistence.Column(name = "municipality_id")
	public Integer getMunicipalityId() {
		return municipalityId;
	}

	/**
	 * @param localityId The localityId to set.
	 */
	public void setMunicipalityId(Integer localityId) {
		this.municipalityId = localityId;
	}

	/**
	 * @return Returns the name of the locality.
	 */
	@javax.persistence.Column(name = "name")
	public String getName() {
		return name;
	}

	/**
	 * @param name The name of the locality to set.
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return Returns the nameLU.
	 */
	@javax.persistence.Column(name = "name_lu")
	public String getLuxembourgishName() {
		return luxembourgishName;
	}

	/**
	 * @param nameLU The nameLU to set.
	 */
	public void setLuxembourgishName (String luxembourgishName) {
		this.luxembourgishName = luxembourgishName;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getName() + " (" + this.getLuxembourgishName() + ")";
    }  
        
}
