/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.address.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>address.type</b> table
 * which stores a list of all available address types
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @Version
 * <br>$Log: AddressType.java,v $
 * <br>Revision 1.6  2008-09-25 09:42:27  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 09:29:39  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.4  2007-12-12 15:10:23  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name="findAllAddressType",
        query="SELECT OBJECT(o) FROM Gender o"),
    @javax.persistence.NamedQuery(name="findAllAddressTypeByValue",
        query="SELECT OBJECT(o) FROM Gender o WHERE o.value = :value")
})

@Entity
@Table(name="type", schema="address")
public class AddressType extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	public static final String PRIVATE = "private";
	public static final String BILLING = "billing";
	public static final String WORK 	 = "work";
	public static final String HIS 	 = "his";
	
	
	/** Regular field. */
	private String value;

	/**
	 * Get the address type.
	 *
	 * @return The address type.
	 */
	@javax.persistence.Column(name = "value")
	public java.lang.String getValue() {
		return value;
	}

	/**
	 * Set the address type.
	 *
	 * @param value The address type.
	 */
	public void setValue(String type) {
		this.value = type;
	}

	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return this.getValue();
    }

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		try {
			return this.getValue().equals(((AddressType)obj).getValue());
		} catch (Exception e) {
			return false;
		}		
	}
    
    
}
