/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as
 * published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * (L-GPL)
 * along with GECAMed. If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor
 * (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lu.tudor.santec.gecamed.core.utils.ServerConfig;

import org.apache.log4j.Logger;

/**
 * 
 * @author Jens Ferring jens.ferring@tudor.lu
 * 
 * @Version
 * <br>$Log: JNLPServlet.java,v $
 */
public class ToolServlet extends HttpServlet
{
	private static final long	serialVersionUID	= 1L;
	
	/** the logger Object for this class */
	private static Logger		logger				= Logger.getLogger(ToolServlet.class.getName());
	
	
	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void doGet (HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException
	{
		response.setContentType("text/html");
		response.setDateHeader("Last-Modified", System.currentTimeMillis());
		PrintWriter out = response.getWriter();
		
		String action = request.getParameter("do");
		
		if (action == null || action.length() == 0) {
			out.println("No Action Given!, Exiting!");
			return;
		}
		
		if (action.equals("checkrmi")) {
			out.println(ServerConfig.checkRMIIP().replaceAll("\n", "<br>"));
		} else if (action.equals("rmiip")) {
			String[] ips = ServerConfig.getRMIIP();
			out.print(ips[0]);
			for (int i = 1; i < ips.length; i++) {
				out.print("#");
				out.print(ips[i]);
			}
			
		}
		
	}
	
}
