package lu.tudor.santec.gecamed.importer.converter;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: MainFrame.java,v $
 */

public class MainFrame extends JFrame
{
	private static final long	serialVersionUID	= 1L;
	
	
	private JButton	convertButton;
	private JButton inputButton;
	private JButton outputButton;
	
	private JFileChooser fileChooser = new JFileChooser();
	
	private File	inputFile;
	private File	outputDir;
	
	
	public MainFrame ()
	{
		setLayout(new GridLayout(0, 1));
		
		inputButton	= new JButton(new AbstractAction("Select the Excel file with the patient info")
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				selectInput();
			}
		});
		
		outputButton	= new JButton(new AbstractAction("Select the XML output directory")
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				selectOutput();
			}
		});
		
		convertButton	= new JButton(new AbstractAction("Start the Excel to XML conversion")
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed (ActionEvent e)
			{
				startConversion();
			}
		});
		convertButton.setEnabled(false);
		
//		// for testing:
//		inputFile	= new File("D:\\Downloads\\patient.xls");
//		outputDir	= new File("D:\\Downloads\\test");
//		convertButton.setEnabled(true);
		
		add(inputButton);
		add(outputButton);
		add(convertButton);
		
		pack();
		setLocationRelativeTo(null);
	}
	
	
	public void setInputFile (File file)
	{
		this.inputFile	= file;
		if (outputDir != null)
			convertButton.setEnabled(true);
	}
	
	
	public void setOutputDir (File dir)
	{
		this.outputDir	= dir;
		if (inputFile != null)
			convertButton.setEnabled(true);
	}
	
	
	
	public static void main (String[] args)
	{
		MainFrame frame = new MainFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		if (args.length > 1)
		{
			frame.setInputFile(new File(args[0]));
			frame.setOutputDir(new File(args[1]));
		}
		
		frame.setVisible(true);
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void selectInput ()
	{
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		fileChooser.setFileFilter(new FileFilter()
		{
			
			@Override
			public String getDescription ()
			{
				return ".xls, .xlsx";
			}
			
			@Override
			public boolean accept (File f)
			{
				return f.isDirectory()
						|| f.getName().endsWith(".xls")
						|| f.getName().endsWith(".xlsx");
			}
		});
		
		if (fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
		{
			setInputFile(fileChooser.getSelectedFile());
		}
	}
	
	
	private void selectOutput ()
	{
		fileChooser.setMultiSelectionEnabled(false);
		fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		fileChooser.setFileFilter(new FileFilter()
		{
			@Override
			public String getDescription ()
			{
				return "Directory";
			}
			
			@Override
			public boolean accept (File f)
			{
				return f.isDirectory();
			}
		});
		
		if (fileChooser.showSaveDialog(this) == JFileChooser.APPROVE_OPTION)
		{
			setOutputDir(fileChooser.getSelectedFile());
		}
	}
	
	
	private void startConversion ()
	{
		ExcelToXmlConverter converter = new ExcelToXmlConverter();
		
		converter.setInputFile(inputFile);
		converter.setOutputDir(outputDir);
		if (converter.convert())
			JOptionPane.showMessageDialog(this, "Conversion successful!", "Successful", JOptionPane.INFORMATION_MESSAGE);
		else
			JOptionPane.showMessageDialog(this, "Error during conversion!", "Error", JOptionPane.ERROR_MESSAGE);
	}
}
