//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.RunNSGMLS
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */

package com.tetrasix.util;

import java.io.*;
import java.awt.*;
import java.util.ResourceBundle;

public class RunNSGMLS {

	static public void check(String filename, Frame frame)
	{
		ResourceBundle _res;

		_res = ResourceBundle.getBundle("com.tetrasix.util.RunNSGMLSResources");

		try {
			String nsgmls = Configuration.getProperty("majix.tool.nsgmls");

			if (filename.endsWith(".xml")) {
				filename = filename.substring(0, filename.length() - 4);
			}

			String command = nsgmls 
					+ " \"-f" + filename + ".err\" \"-t" + filename + ".rast\" \"" + filename + ".xml\"";

			String envp[] = new String[3];
			envp[0] = "SP_CHARSET_FIXED=YES";
			envp[1] = "SP_ENCODING=XML";
			envp[2] = Configuration.getProperty("majix.tool.nsgmls.catalog");

			System.out.println(command);
			try {
				Process p =  Runtime.getRuntime().exec(command, envp);
				p.waitFor();

				filename = filename + ".err";
				File errfile = new File(filename);
				if (errfile.exists()) {
					if (errfile.length() == 0) {
						new MessageBox(frame, _res.getString("no_error_detected"), _res.getString("msgtitle"));
						errfile.delete();
					}
					else {
						String browser = Configuration.getProperty("majix.tool.browser", "explorer.exe");
						Runtime.getRuntime().exec(browser + " \"" + filename + "\"");
					}
				}
				else {
					new MessageBox(frame, _res.getString("no_error_file") + filename, _res.getString("msgtitle"));
				}
			}
			catch (InterruptedException e) {
				new MessageBox(frame, _res.getString("nsgmls_interrupted"), _res.getString("msgtitle"));
			}
		}
		catch (IOException e) {
			new MessageBox(frame, _res.getString("nsgmls_err") + e.getMessage(), _res.getString("msgtitle"));
		}
	}
}