//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.PictWriter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.util;

import java.io.*;

public class PictWriter {

	public static void dumpWMF(String hexdata, String filename,
		int picw, int pich, int picwg, int pichg)
	{
		try {
			FileOutputStream fos = new FileOutputStream(filename);
			BufferedOutputStream bos = new BufferedOutputStream(fos);

			byte header[] = new byte[22];

			// DWORD key = 0x9AC6CDD7L;
			header[0] = (byte)0xD7;
			header[1] = (byte)0xCD;
			header[2] = (byte)0xC6;
			header[3] = (byte)0x9A;
			// HANDLE    hmf;
			header[4] = 0;
			header[5] = 0;
			// RECT      bbox
			// left
			header[6] = 0;
			header[7] = 0;
			// top
			header[8] = 0;
			header[9] = 0;
			// right
			header[10] = (byte)(picw % 255);
			header[11] = (byte)(picw / 255);
			// bottom
			header[12] = (byte)(pich % 255);
			header[13] = (byte)(pich / 255);
			// WORD      inch;
			// header.inch        = (int) ((1440.0 * (double)picw) / (double) picwg);
			int inch = (1440 * picw + (picwg / 2)) / picwg;
			header[14] = (byte)(inch % 255);
			header[15] = (byte)(inch / 255);
			// DWORD     reserved;
			header[16] = 0;
			header[17] = 0;
			header[18] = 0;
			header[19] = 0;
			// WORD      checksum;
			int checksum = 0;
			for (int ii  = 0; ii < 10; ii++) {
				int val = header[ii * 2] + header[ii * 2 + 1] * 255;
				checksum ^= val;
			}
			header[20] = (byte)(checksum % 255);
			header[21] = (byte)(checksum / 255);

			bos.write(header);
			writeHexData(bos, hexdata);

			bos.flush();
			bos.close();
			fos.close();
		}
		catch (IOException e) {
			System.out.println("IO exception : " + e.getMessage());
		}
	}

	static void writeHexData(OutputStream os, String hexdata)throws IOException
	{
		int len = hexdata.length();

		for (int ii = 0; ii < len; ii += 2) {
			String data = hexdata.substring(ii, ii + 2);
			int i = Integer.parseInt(data, 16);
			os.write((byte)i);
		}
	}
}

/*


   struct {
      DWORD     key;     
      HANDLE    hmf;
      RECT      bbox;
      WORD      inch;
      DWORD     reserved;
      WORD      checksum;
   } header;
 
   header.key         = 0x9AC6CDD7L;
   header.hmf         = 0;
   header.bbox.left   = 0;
   header.bbox.top    = 0;
   header.bbox.bottom = pich;
   header.bbox.right  = picw;
   header.inch        = (int) ((1440.0 * (double)picw) / (double) picwg);
   header.checksum    = 0;

   for (bytes = (WORD*)&header, ii = 0; ii < 10; ii++, bytes++) {
       header.checksum ^= *bytes;
   }

   
   write(ofd, (char *)&header, sizeof(header));


*/
