//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.MessageBox
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.util;

import java.util.ResourceBundle;
import java.awt.*;
import java.awt.event.*;

public class MessageBox extends Dialog implements ActionListener {

	public MessageBox(Frame parent, String msg)
	{
		this(parent, msg, "message");
	}

	public MessageBox(Frame parent, String msg, String title)
	{
		super(parent, title, true);

		setSize(400, 100);

		ResourceBundle res = ResourceBundle.getBundle("com.tetrasix.util.MessageBoxResources");

		Button button = new Button(res.getString("ok"));
		button.setActionCommand("quit");
		button.addActionListener(this);

		add("North", new Label(msg));

		Panel panel = new Panel();
		panel.add(button);
		add("South", panel);

		addNotify();
		setLocation (200, 200);
		setVisible(true);
	}

	public MessageBox(Frame parent, String msg[])
	{
		this(parent, msg, "message");
	}

	public MessageBox(Frame parent, String msg[], String title)
	{
		super(parent, title, true);

		setSize(400, 100 + 50 * msg.length);

		ResourceBundle res = ResourceBundle.getBundle("com.tetrasix.util.MessageBoxResources");

		Button button = new Button(res.getString("ok"));
		button.setActionCommand("quit");
		button.addActionListener(this);

		Panel pmsg = new Panel();
		pmsg.setLayout(new FlowLayout(FlowLayout.LEFT, 5, 5));
		for (int ii = 0; ii < msg.length; ii++) {
			pmsg.add(new Label(msg[ii]));
		}
		add("Center", pmsg);

		Panel panel = new Panel();
		panel.add(button);
		add("South", panel);

		addNotify();
		setLocation (200, 200);
		setVisible(true);
	}

	public void actionPerformed(ActionEvent  e)
	{
		String s = e.getActionCommand();

		if ("quit".equals(s)) {
			dispose();
		}
		else {
			System.out.println("unexpected action command : " + s);
		}
	}
}
