//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.FlexibleList
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */

package  com.tetrasix.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public class FlexibleList implements ActionListener {
	
	private Vector _objects;
	private java.awt.List _list;
	private Object _context;
	private int _rows;

	private EditableListElement _elem;

	public FlexibleList(int rows, Object context)
	{
		int listwidthfactor = 1;
		if (   System.getProperty("java.vendor").equals("Microsoft Corp.")) {
			listwidthfactor = 2;
		}
		_context = context;
		_list = new WideList(rows, listwidthfactor);
		_list.addActionListener(this);
		_objects = new Vector();
	}

	public void addItem(EditableListElement obj)
	{
		_objects.addElement(obj);
		_list.add(obj.description());
		obj.setOwner(this);
	}

	public java.awt.List getAwtList()
	{
		return _list;
	}

	public void editSelection()
	{
		if (_elem != null) {
			cancelEditList();
		}

		int sel = _list.getSelectedIndex();
		if (sel >= 0) {
			_elem = (EditableListElement) _objects.elementAt(sel);
			_elem.startEdit(_context);
		}

	}

	public void validateEditList()
	{
		if (_elem != null) {
			_elem.validateEdit(_context);
			refresh();
		}
	}

	public void cancelEditList()
	{
		if (_elem != null) {
			_elem.cancelEdit(_context);
			_elem = null;
		}
	}

	public void removeAll()
	{
		_list.removeAll();
		_objects = new Vector();
	}

	public void update()
	{
		_list.removeAll();

		for (int ii = 0; ii < _objects.size(); ii++) {
			EditableListElement obj = (EditableListElement) _objects.elementAt(ii);
			_list.add(obj.description());
		}
	}

	public void refresh()
	{
		int selected = _list.getSelectedIndex();

		for (int ii = 0; ii < _objects.size(); ii++) {
			EditableListElement obj = (EditableListElement) _objects.elementAt(ii);
			if (obj.isChanged()) {
				_list.replaceItem(obj.description(), ii);
				obj.setChanged(false);
				if (ii == selected) {
					_list.select(selected);
				}
				_list.makeVisible(ii);
			}
		}
	}

	public Enumeration getElements()
	{
		return _objects.elements();
	}

	public void actionPerformed(ActionEvent e)
	{
		editSelection();
	}
}