//===============================================================
// package : com.tetrasix.util
// class : com.tetrasix.util.FilePathUtility
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 * @version 1.1
 */


package com.tetrasix.util;

import java.io.*;

public class FilePathUtility {
	
	public static String getDirectory(String path)
	{
		String dir = "";
		int pos = path.lastIndexOf(File.separator);
		if (pos != -1) {
			dir = path.substring(0, pos);
		}

		return dir;
	}

	public static String getFileName(String path)
	{
		String filename = path;
		int pos = path.lastIndexOf(File.separator);
		if (pos != -1) {
			filename = path.substring(pos + 1);
		}

		pos = filename.lastIndexOf(".");
		if (pos != -1) {
			filename = filename.substring(0, pos);
		}

		return filename;
	}

	public static String SubstituteExtension(String path, String newext)
	{
		int pos = path.lastIndexOf(".");
		if (pos > -1) {
			return path.substring(0, pos) + newext;
		}
		else {
			System.out.println("Bad file name format (extension expected) " + path);
			return null;
		}
	}
}
