//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlWriter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.PrintWriter;
import java.io.OutputStream;

public class XmlWriter extends PrintWriter {

	public XmlWriter(OutputStream os)
	{
		super(os);
	}

	static char toHex(int ch)
	{
		if (ch < 10) {
			return (char)('0' + ch);
		}
		else {
			return (char)('a' + ch - 10);
		}
	}

	/**
	 * Quote a char as &#x<hexcode>.
	 * 
	 * @param ch the char to code
	 * @return the coded char as a String
	 */
	public static String quote(char ch) {
	    if (ch < 0x80) {
	        System.err.println("Senseless quote: '"+ch+"', returning char as string.");
	        return new Character(ch).toString();
	    }
		char chars[] = new char[2];
		chars[0] = toHex(ch / 16);
		chars[1] = toHex(ch % 16);
		return "&#x" + new String(chars) + ";";
	}
	
	public void printQuote(String s)
	{
		int len = s.length();
		for (int ii = 0; ii < len; ii++) {
			char ch = s.charAt(ii);
			if (ch == '\u2002' || ch == '\u2003' || ch == '\u2010' || ch == '\u2011' || ch < 0x80) {
				switch(ch) {
			    case '\n':
					println();
					break;
				case '&':
					print("&amp;");
					break;
				case '<':
					print("&lt;");
					break;
				case  '>':
					print("&gt;");
					break;
				case '"':
					print("&quot;");
					break;
				case '\u2002':
					print("&#x2002;");
					break;
				case '\u2003':
					print("&#x2003;");
					break;
				case '\u2010':
					print("&#x2010;");
					break;
				case '\u2011':
					print("&#x2011;");
					break;
				default:
					print(ch);
				}
			}
			else if (ch < '\u00FF') {
				//switch(ch) {
				//case 0x85:
				//	print("&hellip;");
				//	break;
				//default:
					print(quote(ch));
				//}
			}
			else {
System.out.println("Char "+ch+" not recognized!");
			}
		}
	}
}
	