//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlTagTemplateVariable
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.File;
import java.io.IOException;

import com.jclark.xml.output.XMLWriter;
import com.tetrasix.majix.rtf.RtfExternalEntities;
import com.tetrasix.majix.rtf.RtfExternalEntity;
import com.tetrasix.majix.rtf.RtfInfo;


public class XmlTagTemplateVariable extends XmlTagTemplate {

	ConversionTemplate _template;
	String _key;

	public XmlTagTemplateVariable(String key, ConversionTemplate template)
	{
		_key = key;
		_template = template;
	}

	public String toString()
	{
		if (_key.equals("dtd")) {
			return _template.getGeneratorParam().getDtdName();
		}
		else if (_key.equals("DTDSystemID")) {
			return _template.getGeneratorParam().getDtdSystemId();
		}
		else if (_key.equals("DTDPublicID")) {
			return _template.getGeneratorParam().getDtdPublicId();
		}
		else if (_key.equals("DTDExternalEntityList")) {
			StringBuffer buf = new StringBuffer();

			RtfExternalEntities entities = _theDocument.getExternalEntities();

			String RE = System.getProperty("line.separator");

			String notationName = _template.getGeneratorParam().getActualTag("pnn", true);
			String notationIdent = _template.getGeneratorParam().getActualTag("pni", true);

			if (entities.count() > 0 && ! notationName.equals("") && ! notationIdent.equals("")) {
				buf.append("<!NOTATION " + notationName + " PUBLIC \"" + notationIdent + "\" \"" + notationName + "\">" + RE);
			}

			for (int ii = 0; ii < entities.count(); ii++) {
				RtfExternalEntity entity = entities.getEntity(ii);
				buf.append(getEntityDeclaration(entity));
			}

			return buf.toString();
		}
		else if (_key.equals("info")) {
			String RE = System.getProperty("line.separator");

			StringBuffer buf = new StringBuffer();

			RtfInfo info = _theDocument.getInfo();
		
			String infotag = _template.getGeneratorParam().getActualTag("in", true);
			String include_tag = _template.getGeneratorParam().getAttributes("ip");

			if ((infotag != null) 
                && (info != null)
				&& (infotag.length() != 0)
				&& (include_tag != null)
				&& (include_tag.equals("true"))) {
	
				XmlGeneratorParam param = _template.getGeneratorParam();
                
				boolean not_empty =
					   (param.isDefined("iz") && info.getProperty(RtfInfo.TITLE) != null)
					|| (param.isDefined("is") && info.getProperty(RtfInfo.SUBJECT) != null)
					|| (param.isDefined("ia") && info.getProperty(RtfInfo.AUTHOR) != null)
					|| (param.isDefined("io") && info.getProperty(RtfInfo.OPERATOR) != null)
					|| (param.isDefined("im") && info.getProperty(RtfInfo.MANAGER) != null)
					|| (param.isDefined("ic") && info.getProperty(RtfInfo.COMPANY) != null)
					;

				if (not_empty) {
					buf.append("<" + infotag + ">" + RE);
					add(buf, info, "iz", RtfInfo.TITLE);
					add(buf, info, "is", RtfInfo.SUBJECT);
					add(buf, info, "ia", RtfInfo.AUTHOR);
					add(buf, info, "io", RtfInfo.OPERATOR);
					add(buf, info, "im", RtfInfo.MANAGER);
					add(buf, info, "ic", RtfInfo.COMPANY); 
					buf.append("</" + infotag + ">" + RE);
				}
			}

			return buf.toString();
		}
		else {
			System.out.println("Template variable unknown : " + _key);
			return "";
		}
	}

	void save(XMLWriter writer) throws IOException
	{
		writer.write("\n    ");
		writer.startElement("tt_variable");
		writer.attribute("key", _key);
		writer.endElement("tt_variable");
	}

	String getEntityDeclaration(RtfExternalEntity entity)
	{
		String RE = System.getProperty("line.separator");

		String extension = _template.getGeneratorParam().getActualTag("pe", true);
		if (extension.equals("")) {
			extension = "wmf";
		}

		String notationName = _template.getGeneratorParam().getActualTag("pnn", true);

		if (notationName.equals("")) {
			return "";
		}

		String path = _theDocument.getFileName();
		int pos = path.lastIndexOf(".");
		if (pos >= 0) {
			path = path.substring(0, pos);
		}
		String imagesdir = _template.getGeneratorParam().getActualTag("gd", false);
		String counter = entity.getName();
		path += "_" + counter + "." + extension;
		if (! imagesdir.equals("")) {
			imagesdir += File.separator;
		}

		imagesdir = imagesdir.replace('\\', '/');

		return "<!ENTITY " 
				+ _template.getGeneratorParam().getActualTag("gp", false)
				+ entity.getName()
				+ " SYSTEM \""
				+ imagesdir + path
				+ "\" NDATA " + notationName + ">" + RE;
	}

	static char toHex(int ch)
	{
		if (ch < 10) {
			return (char)('0' + ch);
		}
		else {
			return (char)('a' + ch - 10);
		}
	}

	static String checkChars(String value)
	{
		char chars[] = value.toCharArray();
		StringBuffer buf = new StringBuffer();

		for (int ii = 0; ii < chars.length; ii++) {
			char ch = chars[ii];
			if (ch < 0x80) {
				buf.append(ch);
			}
			else if (ch < '\u00FF') {
				//switch(ch) {
				//case 0x85:
				//	buf.append("&hellip;");
				//	break;
				//default:
					buf.append("&#x");
					buf.append(toHex(ch / 16));
					buf.append(toHex(ch % 16));
					buf.append(";");
				//}
			}
		}

		return buf.toString();
	}

	void add(StringBuffer buf, RtfInfo info, String tagname, int code)
	{
		String RE = System.getProperty("line.separator");

		if (_template.getGeneratorParam().isDefined(tagname)) {
			String value = info.getProperty(code);
			String actualtagname = _template.getGeneratorParam().getActualTag(tagname, true);
			String endtag = _template.getGeneratorParam().getEndTag(tagname);
			if (value != null) {
				buf.append("<" + actualtagname + ">" + checkChars(value) + endtag + RE);
			}
		}
	}
}
