//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlTagTemplate
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.IOException;

import com.jclark.xml.output.XMLWriter;
import com.tetrasix.majix.rtf.RtfDocument;
import com.tetrasix.util.StringList;


public class XmlTagTemplate {
	
	static RtfDocument _theDocument;
	protected StringList _identifiers = null;

	static XmlTagTemplate parse(ConversionTemplate template, String text)
	{
		if (text == null) {
			return new XmlTagTemplateNull();
		}

		if (text.indexOf('<') != -1) {
			XmlTagTemplateList ret = new XmlTagTemplateList();
			int from = 0;
			int pos = 0;

			while ((pos = text.indexOf('<', from)) != -1) {
				if (text.charAt(pos + 1) == '<') {
					pos = pos + 1;
				}
				if (text.charAt(pos + 2) == '<') {
					pos = pos + 2;
				}
				if (text.charAt(pos + 1) == '!') {
					ret.add(new XmlTagTemplateString(text.substring(from, pos + 2)));
					from += 2;
					continue;
				}
				if (pos > 0) {
					ret.add(new XmlTagTemplateString(text.substring(from, pos)));
				}
				if (text.substring(pos + 1, pos + 3).equals("D>")) {
					ret.add(new XmlTagTemplateVariable("dtd", template));
					from = pos + 3;
				}
				else if (text.substring(pos + 1, pos + 3).equals("S>")) {
					ret.add(new XmlTagTemplateVariable("DTDSystemID", template));
					from = pos + 3;
				}
				else if (text.substring(pos + 1, pos + 3).equals("P>")) {
					ret.add(new XmlTagTemplateVariable("DTDPublicID", template));
					from = pos + 3;
				}
				else if (text.substring(pos + 1, pos + 3).equals("E>")) {
					ret.add(new XmlTagTemplateVariable("DTDExternalEntityList",
										template));
					from = pos + 3;
				}
				else if (text.substring(pos + 1, pos + 3).equals("I>")) {
					ret.add(new XmlTagTemplateVariable("info", template));
					from = pos + 3;
				}
				else {
					boolean endtag = false;
					if (text.charAt(pos + 1) == '/') {
						pos ++;
						endtag = true;
					}

					ret.add(new XmlTagTemplateElement(template,
													  text.substring(pos + 1, pos + 3),
													  endtag));
					from = pos + 4;
				}
			}
			
			ret.add(new XmlTagTemplateString(text.substring(from, text.length())));
			
			return ret;
		}
		else {
			return new XmlTagTemplateString(text);
		}
	}

	static void setDocument(RtfDocument theDocument)
	{
		_theDocument = theDocument;
	}

	void setIdentifiers(StringList identifiers)
	{
		_identifiers = identifiers;
	}

	StringList getIdentifiers()
	{
		return _identifiers;
	}

	public String toString(XmlGeneratorFunctor functor)
	{
		return toString();
	}

	void save(XMLWriter writer) throws IOException
	{
		writer.write("\n    ");
		writer.startElement("tt_undefined");
		writer.endElement("tt_undefined");
	}
}


