//===============================================================
// package : com.tetrasix.majix.xml
// class : com.tetrasix.majix.XmlGeneratorParam
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import com.jclark.xml.parse.EntityManagerImpl;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.Parser;
import com.jclark.xml.parse.io.ParserImpl;
import com.tetrasix.util.ISO8859XMLWriter;

public class XmlGeneratorParam implements Cloneable {

	String _dtdname;
	String _dtdsystemid;
	String _dtdpublicid;
	XmlTagMap _tags;

	public XmlGeneratorParam()
	{
		Init();
	}

	public XmlGeneratorParam(ConversionTemplate template, String filename)
	{
		Init();
		_tags = (XmlTagMap) template.getGeneratorParam().getTags().clone();
		try {
			template.initGenParam(this);
			Load(filename);
		}
		catch (IOException e) {
			System.err.println("Error when loading tag definition file " + filename);
		    e.printStackTrace();
		}
	}

	public Object clone()
	{
		XmlGeneratorParam obj = new XmlGeneratorParam();

		obj._dtdname = _dtdname;
		obj._dtdsystemid = _dtdsystemid;
		obj._dtdpublicid = _dtdpublicid;
		obj._tags = (XmlTagMap) _tags.clone();

		return obj;
	}

	public void Init()
	{
		_dtdname = "";
		_dtdsystemid = "";
		_dtdpublicid = "";

		_tags = new XmlTagMap();
	}

	public String getDtdName()
	{
		return _dtdname;
	}

	public void setDtdName(String dtdname)
	{
		_dtdname = dtdname;
	}

	public String getDtdSystemId()
	{
		if (_dtdsystemid == null) {
			return _dtdname + ".dtd";
		}
		else {
			return _dtdsystemid;
		}
	}

	public void setDtdSystemId(String dtdsystemid)
	{
		_dtdsystemid = dtdsystemid;
	}

	public void setDtdPublicId(String dtdpublicid)
	{
		_dtdpublicid = dtdpublicid;
	}

	public String getDtdPublicId()
	{
		return _dtdpublicid;
	}

	public String getActualTag(String tag, boolean with_attribute)
	{
		String tag2 = _tags.getActualTag(tag, with_attribute);
		return tag2;
	}

	public String getStartTag(String tag)
	{
		String s = getActualTag(tag, true);
		if (s.equals("")) {
			return "";
		}
		else {
			return "<" + s + ">";
		}
	}

	public String getEndTag(String tag)
	{
		String s = getActualTag(tag, false);
		if (s.equals("")) {
			return "";
		}
		else {
			return "</" + s + ">";
		}
	}

	/**
	 * Method to determine if a tag-element is defined in the used template.
	 * @param tag  the tag to be examined
	 * @return true if the tag is defined in the template
	 */
	public boolean isDefined(String tag)
	{
		return _tags.isDefined(tag);
	}

	public String getAttributes(String tag)
	{
		String attributes = _tags.getAttributes(tag);
		return attributes;
	}

	public String getAttribute2(String tag)
	{
		String attribute2 = _tags.getAttribute2(tag);
		return attribute2;
	}

	public String getAttribute3(String tag)
	{
		String attribute3 = _tags.getAttribute3(tag);
		return attribute3;
	}

	public boolean getSpecial(String tag)
	{
		return _tags.getSpecial(tag);
	}

	public XmlTagMap getTags()
	{
		return _tags;
	}

	public void Save(String filename) throws IOException
	{
		OutputStream ostream = new FileOutputStream(filename);
		ISO8859XMLWriter writer = new ISO8859XMLWriter(ostream, ISO8859XMLWriter.MINIMIZE_EMPTY_ELEMENTS);

		writer.markup("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");writer.write("\n");

		writer.markup("<!DOCTYPE params [");writer.write("\n");
		writer.markup("<!ELEMENT params (dtdname, dydsysid, dtdpubid, tagmap)>");writer.write("\n");
		writer.markup("<!ATTLIST params majix-version CDATA #REQUIRED>");writer.write("\n");
		writer.markup("<!ELEMENT dtdname  EMPTY>");writer.write("\n");
		writer.markup("<!ATTLIST dtdname name CDATA #REQUIRED>");writer.write("\n");
		writer.markup("<!ELEMENT dtdsysid EMPTY>");writer.write("\n");
		writer.markup("<!ATTLIST dtdsysid name CDATA #REQUIRED>");writer.write("\n");
		writer.markup("<!ELEMENT dtdpubid EMPTY>");writer.write("\n");
		writer.markup("<!ATTLIST dtdpubid name CDATA #REQUIRED>");writer.write("\n");
		writer.markup("<!ELEMENT tagmap (tag+)>");writer.write("\n");
		writer.markup("<!ELEMENT tag EMPTY>");writer.write("\n");
		writer.markup("<!ATTLIST tag id CDATA #REQUIRED");writer.write("\n");
		writer.markup("          category CDATA #REQUIRED");writer.write("\n");
		writer.markup("          gi CDATA #REQUIRED");writer.write("\n");
		writer.markup("          attrs CDATA #IMPLIED>");writer.write("\n");
		writer.markup("]>");writer.write("\n");

		writer.startElement("params");
		writer.attribute("majix-version", "1.0");
		writer.write("\n");

 		writer.startElement("dtdname");
		writer.attribute("name", _dtdname);
		writer.endElement("dtdname");
		writer.write("\n");

		writer.startElement("dtdsysid");
		writer.attribute("name", _dtdsystemid);
		writer.endElement("dtdsysid");
		writer.write("\n");

		writer.startElement("dtdpubid");
		writer.attribute("name", _dtdpublicid);
		writer.endElement("dtdpubid");
		writer.write("\n");

 		_tags.Save(writer, false);

		writer.endElement("params");writer.write("\n");

		writer.flush();
		ostream.close();
	}

	public void Load(String filename) throws IOException
	{
		Parser parser = new ParserImpl();
		OpenEntity entity = EntityManagerImpl.openFile(filename);

		parser.setApplication(new XmlGeneratorParamLoaderApplication());
		parser.parseDocument(entity);
	}

	private class XmlGeneratorParamLoaderApplication extends ApplicationImpl {

		public void startElement(StartElementEvent event) throws IOException
		{
			int    type = 0;
			String ename = null;
			String astyle = null;
			String atag = null;

			if (event.getName().equals("dtdname")) {
				_dtdname = event.getAttributeValue("name");
			}
			else if (event.getName().equals("dtdsysid")) {
				_dtdsystemid = event.getAttributeValue("name");
			}
			else if (event.getName().equals("dtdpubid")) {
				_dtdpublicid = event.getAttributeValue("name");
			}
			else if (event.getName().equals("tag")) {
				_tags.load(event, false);
			}
		}
	}
}