//===============================================================
// package : com.tetrasix.majix.uis
// class : com.tetrasix.majix.uis.ShellSplitter
//===============================================================
// The contents of this file are subject to the Mozilla Public License
// Version 1.1 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at
// http://www.mozilla.org/MPL/
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
// License for the specific language governing rights and limitations
// under the License.
//
// The Original Code is TetraSys code.
//
// The Initial Developer of the Original Code is TetraSys..
// Portions created by TetraSys are 
// Copyright (C) 1998-2000 TetraSys. All Rights Reserved.
//
// Contributor(s): Arne Jans, Quinscape GmbH (www.quinscape.de)
//===============================================================


/**
 *
 * @version 1.1
 */


package com.tetrasix.majix.uis;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import com.tetrasix.majix.tools.InsertToc;
import com.tetrasix.majix.tools.Splitter;
import com.tetrasix.util.Configuration;
import com.tetrasix.util.HtmlBrowser;
import com.tetrasix.util.MessageBox;
import com.tetrasix.util.RunXT;

public class ShellSplitter extends JFrame 
		implements ActionListener, FocusListener, KeyListener {

	private Frame _owner;

	private JButton _closeButton;
	private JButton _helpButton;
	private JButton _runButton;

	private JTextField _xmlTextField;
	private JButton _findDocumentButton;
	private JTextField _rootTextField;

	private JTextField _xslTextField = null;
	private JButton _findStylesheetButton;

	ResourceBundle _res;
	static private String _filesep = System.getProperty("file.separator");

	private static final String _HELP_TOPIC = "shell_splitter";
	private static final int _DEFAULT_WIDTH = 700;
    private static final int _DEFAULT_HEIGHT = 260;

	public ShellSplitter(Frame owner)
	{
		_res = ResourceBundle.getBundle("com.tetrasix.majix.uis.ShellSplitterResources");

		setTitle(_res.getString("frame_title"));

		_owner = owner;

		enableEvents(AWTEvent.WINDOW_EVENT_MASK);

		build();

		//setSize(_DEFAULT_WIDTH, _DEFAULT_HEIGHT);
        pack();
		center();
		show();
        LFlist.add(this);
	}
	
    private void build()
    {
        GridBagLayout layout = new GridBagLayout();
        getContentPane().setLayout(layout);
        
        addComponent(this, new JLabel(_res.getString("xml_text_label")),
                     0, 0, 1, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        addComponent(this, _xmlTextField = new JTextField(48),
                     1, 0, 3, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        _xmlTextField.addActionListener(this);
        _xmlTextField.addFocusListener(this);
        _xmlTextField.addKeyListener(this);
        addComponent(this, _findDocumentButton = new JButton(_res.getString("find_file_button")),
                     4, 0, 1, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        _findDocumentButton.setActionCommand("find_file");
        _findDocumentButton.addActionListener(this);


        addComponent(this, new JLabel(_res.getString("root_text_label")),
                     0, 1, 1, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        addComponent(this, _rootTextField = new JTextField(10),
                     1, 1, 3, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        _rootTextField.addActionListener(this);
        _rootTextField.addFocusListener(this);
        _rootTextField.addKeyListener(this);


        addComponent(this, new JLabel(_res.getString("xsl_text_label")),
                     0, 2, 1, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        addComponent(this, _xslTextField = new JTextField(48),
                     1, 2, 3, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        _xslTextField.addActionListener(this);
        _xslTextField.addFocusListener(this);
        _xslTextField.addKeyListener(this);
        addComponent(this, _findStylesheetButton = new JButton(_res.getString("find_stylesheet_button")),
                     4, 2, 1, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.WEST);
        _findStylesheetButton.setActionCommand("find_stylesheet");
        _findStylesheetButton.addActionListener(this);

        JPanel pbutton = new JPanel();

        if (Configuration.getProperty("majix.enable.doc").equals("1")) {
            pbutton.add( _helpButton = new JButton(_res.getString("help_button")));
            _helpButton.setActionCommand("help");
            _helpButton.addActionListener(this);
        }

        pbutton.add( _runButton = new JButton(_res.getString("run_button")));
        _runButton.setActionCommand("run");
        _runButton.addActionListener(this);

        pbutton.add( _closeButton = new JButton(_res.getString("close_button")));
        _closeButton.setActionCommand("close");
        _closeButton.addActionListener(this);


        addComponent(this, pbutton,
                     1, 3, 3, 1, 
                     GridBagConstraints.NONE, GridBagConstraints.CENTER);

        CheckRunButton();

        setBackground(SystemColor.control);
    }
    
    private static void addComponent (
        JFrame container, Component component, 
        int gridx, int gridy, int gridwidth, int gridheight,
        int fill, int anchor)
    {
        LayoutManager lm = container.getContentPane().getLayout();
        if (! (lm instanceof GridBagLayout)) {
              System.out.println("Invalid layout : " + lm);
              container.getContentPane().add(component);
              return;
        }
        
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)lm).setConstraints(component, gbc);
        container.getContentPane().add(component);
    }

	void center()
	{
		Dimension wd = getSize();
		Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();

		setLocation((sd.width - wd.width) / 2, (sd.height - wd.height) / 2);
	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() instanceof JButton) {
			String s = e.getActionCommand();
	
			if (s.equals("close")) {
				setVisible(false);
                LFlist.remove(this);
				dispose();
			}
			else if (s.equals("help")) {
				showHelp();
			}
			else if (s.equals("run")) {

				if (   checkFile(_xmlTextField.getText())) {

					String stylesheet;
					if (_xslTextField != null) {
						stylesheet = _xslTextField.getText();
						if ( !checkFile(_xmlTextField.getText())) {
							return;
						}
					}
					else {
						stylesheet = null;
					}
					split(_xmlTextField.getText(), _rootTextField.getText(), stylesheet, this);
				}
			}
			else if (s.equals("find_file")) {
				findFile();
			}
			else if (s.equals("find_stylesheet")) {
				findStylesheet();
			}
			else {
				System.out.println("unexpected action command : " + s);
			}
		}
		else if (e.getSource() instanceof JTextField) {
			CheckRunButton();
		}
	}

	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			setVisible(false);
            LFlist.remove(this);
			dispose();
		}
		else {
			super.processWindowEvent(e);
		}
	}

	private void showHelp()
	{
		ShowHelp.load(_HELP_TOPIC);
	}

	public void focusGained(FocusEvent e)
	{
	}

	public void focusLost(FocusEvent e)
	{
		if (e.getSource() == _xmlTextField) {
			CheckRunButton();
		}
		if (e.getSource() == _xslTextField) {
			CheckRunButton();
		}
		if (e.getSource() == _rootTextField) {
			CheckRunButton();
		}
	}

		public void keyPressed(KeyEvent e)
	{
	}

	public void keyReleased(KeyEvent e)
	{
		if (e.getSource() == _xmlTextField) {
			CheckRunButton();
		}
		if (e.getSource() == _xslTextField) {
			CheckRunButton();
		}
		if (e.getSource() == _rootTextField) {
			CheckRunButton();
		}
	}

	public void keyTyped(KeyEvent e)
	{
	}

	private void CheckRunButton()
	{
		_runButton.setEnabled(
			     ! _xmlTextField.getText().equals("")
			  && ((_xslTextField == null) || ! _xslTextField.getText().equals(""))
			  && ! _rootTextField.getText().equals("")
			  );
	}

	public boolean checkFile(String filename)
	{
		File f = new File(filename);

		if (f.exists() && f.isFile()) {
			return true;
		}
		else {
			String msg[] = new String[2];
			msg[0] = _res.getString("no_such_file");
			msg[1] = "   " + filename;
			new MessageBox(this, msg);
			return false;
		}
	}

	private void findFile()
	{
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select XML file");
        FileFilter filter = new ExtensionFileFilter("xml", "XML files");
        chooser.setFileFilter(filter);
        
		int option = chooser.showOpenDialog(this);
        if (option == JFileChooser.APPROVE_OPTION) {
			String docfilename = chooser.getSelectedFile().getAbsolutePath();
			_xmlTextField.setText(docfilename);
		}
		CheckRunButton();
	}

 	private void findStylesheet()
	{
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        chooser.setDialogTitle("Select XSL stylesheet file");
        FileFilter filter = new ExtensionFileFilter("xsl", "XSL files");
        chooser.setFileFilter(filter);

        int option = chooser.showOpenDialog(this);
        if (option == JFileChooser.APPROVE_OPTION) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            _xslTextField.setText(filename);
        }
		CheckRunButton();
	}

	private void split(String xmlfilename, String root, String stylesheet, Frame frame)
	{
		if (root.toLowerCase().endsWith(".xml")) {
			root = root.substring(0, root.length() - 4);
		}

		File xmlfile = new File(xmlfilename);

		String outfileroot = root;
		String outdirroot = xmlfile.getParent();

		int pos = root.lastIndexOf(_filesep);
		if (pos > -1) {
			outdirroot = root.substring(0, pos);
			outfileroot = root.substring(pos + 1);
		}

		int nbparts = Splitter.split(xmlfilename, outfileroot, outdirroot);

		if (stylesheet != null) {
			File stylesheetfile = new File(stylesheet);
			String mytocxsl =  stylesheetfile.getParent() + File.separator + "mytoc.xsl";
			String tocnamehtml = outdirroot + _filesep + outfileroot + "_toc.html";
			RunXT.apply(outdirroot + _filesep + outfileroot + "_toc.xml", mytocxsl, false, this);
		

			RunXT.apply(outdirroot + _filesep + outfileroot + ".xml", stylesheet, false, this);
			InsertToc.insert(outdirroot + _filesep + outfileroot + ".html", tocnamehtml, outdirroot + _filesep + "default.html");

			for (int ii = 1; ii <= nbparts; ii++) {
				String spartcount = String.valueOf(ii);
				while (spartcount.length() < 3) {
					spartcount = "0" + spartcount;
				}
				String partname_xml = outdirroot + _filesep + outfileroot + "_" + spartcount + ".xml";
				String partname_html = outdirroot + _filesep + outfileroot + "_" + spartcount + ".html";
				RunXT.apply(partname_xml, stylesheet, false, frame);
				InsertToc.insert(partname_html, tocnamehtml);
			}

			String browser = Configuration.getProperty("majix.tool.browser", "explorer.exe");
			HtmlBrowser.browse(outdirroot + _filesep + "default.html");
		}
	}
}